/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.classutils;

import com.rameses.classutils.AnnotationFieldHandler;
import com.rameses.classutils.ClassDef;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;

public final class ClassDefUtil {
    private static ClassDefUtil instance;
    private AnnotationFieldHandler handler;
    private Map<Class, ClassDef> map = new Hashtable<Class, ClassDef>();

    private ClassDefUtil() {
    }

    public static ClassDefUtil getInstance() {
        if (instance == null) {
            instance = new ClassDefUtil();
        }
        return instance;
    }

    public void injectFields(Object o) {
        this.injectFields(o, this.handler);
    }

    public void injectFields(Object o, AnnotationFieldHandler h) {
        Class<?> clazz = o.getClass();
        this.injectFields(o, clazz, h);
    }

    public void injectFields(Object o, Class clazz, AnnotationFieldHandler h) {
        this.parseClass(clazz);
        ClassDef classDef = this.map.get(clazz);
        classDef.injectFields(o, h);
        if (clazz.getSuperclass() != null) {
            this.injectFields(o, clazz.getSuperclass(), h);
        }
    }

    public void parseClass(Class clazz) {
        if (!this.map.containsKey(clazz)) {
            ClassDef classDef = new ClassDef(clazz);
            this.map.put(clazz, classDef);
        }
    }

    public void clearAll() {
        for (ClassDef c : this.map.values()) {
            c.destroy();
        }
        this.map.clear();
    }

    public void clear(Class clazz) {
        ClassDef c = this.map.get(clazz);
        if (c != null) {
            c.destroy();
        }
        this.map.remove(clazz);
    }

    public Method findAnnotatedMethod(Class clazz, Class a) {
        this.parseClass(clazz);
        return this.map.get(clazz).findAnnotatedMethod(a);
    }

    public Method[] findAnnotatedMethods(Class clazz, Class a) {
        this.parseClass(clazz);
        return this.map.get(clazz).findAnnotatedMethods(a);
    }

    public Method findMethodByName(Class clazz, String methodName) {
        this.parseClass(clazz);
        return this.map.get(clazz).findMethodByName(methodName);
    }

    public Field findAnnotatedField(Class clazz, Class a) {
        this.parseClass(clazz);
        return this.map.get(clazz).findAnnotatedField(a);
    }
}

