/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.classutils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ClassDefMap {
    public static Map toMap(Class clazz) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", clazz.getSimpleName());
        if (clazz.getPackage() != null) {
            map.put("package", clazz.getPackage().getName());
        }
        map.put("fullname", clazz.getName());
        ArrayList<Map> methods = new ArrayList<Map>();
        for (Method m : clazz.getDeclaredMethods()) {
            Map method = ClassDefMap.getMethodInfo(m);
            methods.add(method);
        }
        map.put("methods", methods);
        return map;
    }

    private static Map getMethodInfo(Method m) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("returnType", m.getReturnType().getName());
        map.put("name", m.getName());
        ArrayList<String> params = new ArrayList<String>();
        boolean i = false;
        for (Class<?> c : m.getParameterTypes()) {
            params.add(c.getName());
        }
        map.put("params", params);
        return map;
    }
}

