/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.classutils;

import com.rameses.classutils.AnnotationField;
import com.rameses.classutils.AnnotationFieldHandler;
import com.rameses.classutils.AnnotationMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class ClassDef {
    private Class clazz;
    private List<AnnotationField> annotatedFields;
    private List<AnnotationMethod> annotatedMethods;
    private List<Method> methods;
    private AnnotationFieldHandler handler;

    public ClassDef(Class clazz) {
        this.clazz = clazz;
        this.annotatedFields = new ArrayList<AnnotationField>();
        this.annotatedMethods = new ArrayList<AnnotationMethod>();
        this.methods = new ArrayList<Method>();
        this.scanFields(clazz);
        this.scanMethods(clazz);
    }

    private void scanFields(Class clazz) {
        if (clazz == null) {
            return;
        }
        for (Field f : clazz.getDeclaredFields()) {
            for (Annotation a : f.getAnnotations()) {
                this.annotatedFields.add(new AnnotationField(f, a));
            }
        }
        if (clazz.getSuperclass() != null && !clazz.equals(Object.class)) {
            this.scanFields(clazz.getSuperclass());
        }
    }

    private void scanMethods(Class clazz) {
        if (clazz == null) {
            return;
        }
        for (Method m : clazz.getDeclaredMethods()) {
            for (Annotation a : m.getAnnotations()) {
                this.annotatedMethods.add(new AnnotationMethod(m, a));
            }
            this.methods.add(m);
        }
        if (clazz.getSuperclass() != null && !clazz.equals(Object.class)) {
            this.scanMethods(clazz.getSuperclass());
        }
    }

    public AnnotationFieldHandler getHandler() {
        return this.handler;
    }

    public void setHandler(AnnotationFieldHandler handler) {
        this.handler = handler;
    }

    public void injectFields(Object o) {
        if (this.handler == null) {
            throw new RuntimeException("Please provide an annotation handler");
        }
        this.injectFields(o, this.getHandler());
    }

    public void injectFields(Object o, AnnotationFieldHandler handler) {
        for (AnnotationField f : this.annotatedFields) {
            Field fld = f.getField();
            Annotation annot = f.getAnnotation();
            try {
                Object res = handler.getResource(o, fld, annot);
                if (res == null) continue;
                boolean accessible = fld.isAccessible();
                fld.setAccessible(true);
                fld.set(o, res);
                fld.setAccessible(accessible);
            }
            catch (Exception ex) {
                System.out.println("ERROR field->" + fld.getName() + " annotation->" + annot + " " + ex.getMessage());
            }
        }
    }

    public <T> T findClassAnnotation(Class<T> a) {
        for (Annotation an : this.clazz.getAnnotations()) {
            if (!an.annotationType().getName().equals(a.getName())) continue;
            return (T)an;
        }
        return null;
    }

    public Method findAnnotatedMethod(Class a) {
        for (AnnotationMethod m : this.annotatedMethods) {
            if (!m.getAnnotation().annotationType().getName().equals(a.getName())) continue;
            return m.getMethod();
        }
        return null;
    }

    public Method[] findAnnotatedMethods(Class a) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (AnnotationMethod m : this.annotatedMethods) {
            if (!m.getAnnotation().annotationType().getName().equals(a.getName())) continue;
            list.add(m.getMethod());
        }
        return list.toArray(new Method[0]);
    }

    public Method findMethodByName(String methodName) {
        for (Method m : this.methods) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }

    public Field findAnnotatedField(Class a) {
        for (AnnotationField field : this.annotatedFields) {
            if (field.getAnnotation().annotationType() != a) continue;
            return field.getField();
        }
        return null;
    }

    public void destroy() {
        this.annotatedFields.clear();
        this.annotatedMethods.clear();
        this.methods.clear();
        this.clazz = null;
        this.annotatedFields = null;
        this.annotatedMethods = null;
        this.methods = null;
        this.handler = null;
    }

    public Class getSource() {
        return this.clazz;
    }

    public List<AnnotationField> getAnnotatedFields() {
        return this.annotatedFields;
    }

    public List<AnnotationMethod> getAnnotatedMethods() {
        return this.annotatedMethods;
    }
}

