/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.microutil;

import com.topaz.sigplus.microutil.MicroSigDataType;
import com.topaz.sigplus.microutil.MicroTabletParameters;
import com.topaz.sigplus.microutil.TabletPoint;
import java.util.Vector;

public class MicroTabletInterface
implements Runnable {
    private static final int MaxFilterPoints = 16;
    private int penState;
    private TabletPoint lastPoint;
    private Vector savedSamples;
    private TabletPoint[] filter;
    int nextFilterPoint;
    private MicroSigDataType theSig;
    public MicroTabletParameters params;
    boolean timeToDie;
    Thread readThread;
    byte[] inputBuffer;
    int inputBufferSize;
    int inputBufferHead;
    int inputBufferTail;
    boolean tabletStatus;
    byte[] readBuffer;
    static final int WaitingForNear = 0;
    static final int NearWaitingForPenDown = 1;
    static final int PenDownState = 2;
    static final int PenUpState = 3;
    public int badPointCounter;
    long modelNumber;
    byte[] nonPointCmdBuffer;
    int nonPointCmdBytes;
    int serialInputState;
    long serialNumber;
    static final int StatusCmdData = 3;
    static final int StatusSerialNoData = 2;
    static final int WaitForRestOfPacket = 2;
    static final int WaitForSecondByte = 1;
    static final int WaitForStartByte = 0;

    public MicroTabletInterface(MicroTabletParameters newParams, MicroSigDataType newSig) {
        this.params = newParams;
        this.theSig = newSig;
        this.penState = 0;
        this.lastPoint = new TabletPoint();
        this.savedSamples = new Vector();
        this.filter = new TabletPoint[16];
        this.nextFilterPoint = 0;
        this.inputBufferSize = 8192;
        this.inputBufferHead = 0;
        this.inputBufferTail = 0;
        this.inputBuffer = new byte[this.inputBufferSize];
        this.readBuffer = new byte[this.inputBufferSize];
        this.serialNumber = 0L;
        this.modelNumber = 0L;
        this.nonPointCmdBuffer = new byte[32];
        this.nonPointCmdBytes = 0;
        this.badPointCounter = 0;
    }

    public boolean openTablet() {
        this.params.tabletComPort.substring(0, 3);
        this.tabletStatus = true;
        this.timeToDie = false;
        this.readThread = new Thread(this);
        this.readThread.start();
        return true;
    }

    public boolean closeTablet() {
        if (!this.tabletStatus) {
            return false;
        }
        this.tabletStatus = false;
        this.timeToDie = true;
        return true;
    }

    public void run() {
        this.processSerialInput();
    }

    public synchronized void addToInputBuffer(byte[] inBuff, int numBytes) {
        int i = 0;
        while (i < numBytes) {
            this.inputBuffer[this.inputBufferTail] = inBuff[i];
            int tempTail = this.inputBufferTail;
            if (++tempTail == this.inputBufferSize) {
                tempTail = 0;
            }
            if (tempTail != this.inputBufferHead) {
                this.inputBufferTail = tempTail;
            }
            ++i;
        }
    }

    public synchronized int bytesInInputBuffer() {
        int count = this.inputBufferTail - this.inputBufferHead;
        if (count < 0) {
            return count + this.inputBufferSize;
        }
        return count;
    }

    synchronized byte getFromInputBuffer() {
        if (this.inputBufferHead == this.inputBufferTail) {
            return 0;
        }
        byte value = this.inputBuffer[this.inputBufferHead++];
        if (this.inputBufferHead == this.inputBufferSize) {
            this.inputBufferHead = 0;
        }
        return value;
    }

    boolean isStartByte(byte value) {
        return (value & 0x80) != 0;
    }

    int convertCoordData(byte lsb, byte msb) {
        int pos = msb;
        pos &= 0x1F;
        pos <<= 7;
        return pos += lsb & 0x7F;
    }

    boolean isPenDown(int status) {
        return (status & 1) != 0;
    }

    int setPenDown(int status) {
        return status | 1;
    }

    boolean isPenNear(int status) {
        return (status & 0x40) != 0;
    }

    int setPenNear(int status) {
        return status | 0x40;
    }

    boolean isBadPacket(byte[] buffer) {
        if ((buffer[1] & 0x80) != 0 || (buffer[2] & 0xE0) != 0 || (buffer[3] & 0x80) != 0 || (buffer[4] & 0xE0) != 0) {
            return true;
        }
        if ((buffer[1] & 0x7F) == 127 && (buffer[2] & 0x1F) == 31 && (buffer[3] & 0x7F) == 127 && (buffer[4] & 0x1F) == 31) {
            ++this.badPointCounter;
            return true;
        }
        return false;
    }

    void scaleCoordData(TabletPoint tPoint) {
        int newX;
        int newY;
        switch (this.params.getTabletRotationMode()) {
            case 90: {
                newY = tPoint.x - this.params.tabletXStart;
                newY *= this.params.tabletLogicalYSize;
                newY /= this.params.tabletXStop - this.params.tabletXStart;
                newX = tPoint.y - this.params.tabletYStop;
                newX *= this.params.tabletLogicalXSize;
                newX /= this.params.tabletYStart - this.params.tabletYStop;
                break;
            }
            case 180: {
                newX = tPoint.x - this.params.tabletXStop;
                newX *= this.params.tabletLogicalXSize;
                newX /= this.params.tabletXStart - this.params.tabletXStop;
                newY = tPoint.y - this.params.tabletYStop;
                newY *= this.params.tabletLogicalYSize;
                newY /= this.params.tabletYStart - this.params.tabletYStop;
                break;
            }
            case 270: {
                newY = tPoint.x - this.params.tabletXStop;
                newY *= this.params.tabletLogicalYSize;
                newY /= this.params.tabletXStart - this.params.tabletXStop;
                newX = tPoint.y - this.params.tabletYStart;
                newX *= this.params.tabletLogicalXSize;
                newX /= this.params.tabletYStop - this.params.tabletYStart;
                break;
            }
            default: {
                newX = tPoint.x - this.params.tabletXStart;
                newX *= this.params.tabletLogicalXSize;
                newX /= this.params.tabletXStop - this.params.tabletXStart;
                newY = tPoint.y - this.params.tabletYStart;
                newY *= this.params.tabletLogicalYSize;
                newY /= this.params.tabletYStop - this.params.tabletYStart;
            }
        }
        if (newX < 0) {
            newX = 0;
        }
        if (newX > this.params.tabletLogicalXSize) {
            newX = this.params.tabletLogicalXSize;
        }
        tPoint.x = newX;
        if (newY < 0) {
            newY = 0;
        }
        if (newY > this.params.tabletLogicalYSize) {
            newY = this.params.tabletLogicalYSize;
        }
        tPoint.y = newY;
    }

    void processTabletSample(TabletPoint tPoint) {
        switch (this.penState) {
            case 0: {
                if (!this.isPenNear(tPoint.status) && !this.isPenDown(tPoint.status)) break;
                this.penState = 1;
                break;
            }
            case 1: {
                if (this.isPenDown(tPoint.status)) {
                    TabletPoint samp;
                    this.penState = 2;
                    this.savedSamples.addElement(tPoint);
                    while (this.savedSamples.size() > 0) {
                        samp = (TabletPoint)this.savedSamples.elementAt(0);
                        this.savedSamples.removeElementAt(0);
                        if (this.onPenDown(samp)) break;
                    }
                    while (this.savedSamples.size() > 0) {
                        samp = (TabletPoint)this.savedSamples.elementAt(0);
                        this.savedSamples.removeElementAt(0);
                        this.onPenMove(samp);
                    }
                } else {
                    if (!this.isPenNear(tPoint.status)) {
                        this.penState = 0;
                        break;
                    }
                    this.savedSamples.addElement(tPoint);
                    while (this.savedSamples.size() > this.params.tabletTimingAdvance) {
                        this.savedSamples.removeElementAt(0);
                    }
                }
                break;
            }
            case 2: {
                if (!this.isPenDown(tPoint.status)) {
                    this.penState = 3;
                    this.onPenUp(tPoint);
                    break;
                }
                if (!this.samplesAreDifferent(tPoint, this.lastPoint)) break;
                this.onPenMove(tPoint);
                break;
            }
            case 3: {
                if (this.isPenDown(tPoint.status)) {
                    this.penState = 2;
                    this.onPenDown(tPoint);
                    break;
                }
                if (this.isPenNear(tPoint.status)) break;
                this.penState = 0;
                break;
            }
        }
        this.lastPoint = tPoint;
    }

    boolean samplesAreDifferent(TabletPoint a, TabletPoint b) {
        int deltaX = a.x - b.x;
        int deltaY = a.y - b.y;
        if (deltaX > this.params.tabletMaxPointDelta || deltaX < -this.params.tabletMaxPointDelta) {
            ++this.badPointCounter;
            return false;
        }
        if (deltaY > this.params.tabletMaxPointDelta || deltaY < -this.params.tabletMaxPointDelta) {
            ++this.badPointCounter;
            return false;
        }
        return a.x != b.x || a.y != b.y;
    }

    void onPenUp(TabletPoint tPoint) {
        int i = 0;
        while (i < this.params.tabletFilterPoints) {
            TabletPoint filteredPoint = this.filterPoint(tPoint);
            this.addPointToCurrentStroke(filteredPoint);
            ++i;
        }
    }

    void onPenMove(TabletPoint tPoint) {
        TabletPoint filteredPoint = this.filterPoint(tPoint);
        this.addPointToCurrentStroke(filteredPoint);
    }

    void initializeFilter(TabletPoint tPoint) {
        int i = 0;
        while (i < this.params.tabletFilterPoints) {
            this.filter[i] = tPoint;
            ++i;
        }
        this.nextFilterPoint = 0;
    }

    TabletPoint filterPoint(TabletPoint tPoint) {
        TabletPoint value = new TabletPoint();
        this.filter[this.nextFilterPoint++] = tPoint;
        if (this.nextFilterPoint == this.params.tabletFilterPoints) {
            this.nextFilterPoint = 0;
        }
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.params.tabletFilterPoints) {
            x += this.filter[i].x;
            y += this.filter[i].y;
            ++i;
        }
        value.x = x / this.params.tabletFilterPoints;
        value.y = y / this.params.tabletFilterPoints;
        value.status = tPoint.status;
        return value;
    }

    void newStroke() {
        if (this.theSig != null) {
            this.theSig.addNewStroke();
        }
    }

    void addPointToCurrentStroke(TabletPoint tPoint) {
        if (this.theSig != null) {
            this.theSig.addNewPoint(tPoint.x, tPoint.y);
        }
    }

    public long getTabletModelNumber() {
        byte[] cmdStr = new byte[]{0};
        if (this.tabletStatus) {
            this.writeCommand(cmdStr);
            this.sleep(100);
        }
        return this.modelNumber;
    }

    public long getTabletSerialNumber() {
        byte[] cmdStr = new byte[]{0};
        if (this.tabletStatus) {
            this.writeCommand(cmdStr);
            this.sleep(100);
        }
        return this.serialNumber;
    }

    public boolean isSerialPenData(byte statusByte) {
        switch (statusByte) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return true;
            }
            case 5: {
                return false;
            }
            case 6: {
                return false;
            }
            case 7: {
                return false;
            }
        }
        return false;
    }

    boolean onPenDown(TabletPoint tPoint) {
        this.initializeFilter(tPoint);
        this.newStroke();
        this.addPointToCurrentStroke(tPoint);
        return true;
    }

    public void processNonPointData(int statusPacketType, byte[] statusPacketData) {
        switch (statusPacketType) {
            case 2: {
                this.modelNumber = (statusPacketData[0] & 0xFC) >> 2;
                this.serialNumber = statusPacketData[0] & 3;
                this.serialNumber <<= 8;
                this.serialNumber |= (long)statusPacketData[1];
                this.serialNumber <<= 8;
                this.serialNumber |= (long)statusPacketData[2];
                this.serialNumber &= 0x3FFFFL;
                break;
            }
            case 3: {
                if (this.nonPointCmdBytes >= this.nonPointCmdBuffer.length) break;
                this.nonPointCmdBuffer[this.nonPointCmdBytes++] = statusPacketData[2];
                break;
            }
        }
    }

    public void processSerialCmdData(byte cmdByte) {
        byte[] cmdBytes = new byte[]{1, 17, cmdByte};
        this.processNonPointData(3, cmdBytes);
    }

    public void processSerialInput() {
        byte[] scratch = new byte[5];
        byte lastByte = 0;
        int serialPacketIndex = 0;
        int pointsSinceLastSleep = 0;
        this.serialInputState = 0;
        while (!this.timeToDie) {
            int bytesInBuffer = this.bytesInInputBuffer();
            if (bytesInBuffer == 0) {
                this.sleep(20);
                if (this.serialInputState != 1 || (bytesInBuffer = this.bytesInInputBuffer()) != 0) continue;
                this.processSerialCmdData(lastByte);
                this.serialInputState = 0;
                continue;
            }
            byte thisByte = this.getFromInputBuffer();
            if (this.serialInputState == 0) {
                if (!this.isStartByte(thisByte)) {
                    this.processSerialCmdData(thisByte);
                    continue;
                }
                lastByte = thisByte;
                this.serialInputState = 1;
                continue;
            }
            if (this.serialInputState == 1) {
                if (this.isStartByte(thisByte)) {
                    this.processSerialCmdData(lastByte);
                    scratch[0] = thisByte;
                    serialPacketIndex = 1;
                    this.serialInputState = 2;
                    continue;
                }
                scratch[0] = lastByte;
                scratch[1] = thisByte;
                serialPacketIndex = 2;
                this.serialInputState = 2;
                continue;
            }
            if (this.serialInputState != 2) continue;
            if (serialPacketIndex >= 5) {
                this.serialInputState = 0;
                continue;
            }
            scratch[serialPacketIndex++] = thisByte;
            if (serialPacketIndex != 5) continue;
            this.serialInputState = 0;
            int x = this.convertCoordData(scratch[1], scratch[2]);
            int y = this.convertCoordData(scratch[3], scratch[4]);
            int status = scratch[0] & 0xFF;
            if (this.isBadPacket(scratch)) continue;
            if (!this.isSerialPenData((byte)(scratch[0] >> 2 & 7))) {
                this.sendSerialNPData(scratch[0], x, y);
                continue;
            }
            TabletPoint tPoint = new TabletPoint(x, y, status);
            this.scaleCoordData(tPoint);
            this.processTabletSample(tPoint);
            if (++pointsSinceLastSleep <= 10) continue;
            this.sleep(10);
            pointsSinceLastSleep = 0;
        }
        return;
    }

    public void resetNonPointCmdBuffer() {
        this.nonPointCmdBytes = 0;
    }

    public synchronized void resetSerialInputState() {
        this.serialInputState = 0;
    }

    public void sendSerialNPData(byte statusByte, int xPos, int yPos) {
        byte[] cmdBytes = new byte[]{(byte)(xPos >> 4), (byte)((xPos & 0xF) << 4 | (yPos & 0xF00) >> 8), (byte)(yPos & 0xFF)};
        this.processNonPointData(statusByte >> 2 & 7, cmdBytes);
    }

    public void sleep(int timeInMs) {
        try {
            Thread.sleep(timeInMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean waitForNonPointCmdData(long timeoutInMs, int numBytes) {
        long sleepCount = timeoutInMs / 10L;
        while (this.nonPointCmdBytes < numBytes) {
            if (sleepCount-- <= 0L) {
                return false;
            }
            this.sleep(10);
        }
        return true;
    }

    public void writeCommand(byte[] cmdString) {
    }
}

