/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.custom.impl;

import com.rameses.common.FunctionResolver;
import com.rameses.custom.impl.JsonUtil;
import com.rameses.io.StreamUtil;
import com.rameses.util.URLDirectory;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BasicFunctionResolver
extends FunctionResolver {
    private Map<String, Map> functions;

    private void buildMap() {
        if (this.functions == null) {
            try {
                CustomFilter cf = new CustomFilter();
                ClassLoader loader = FunctionResolver.class.getClassLoader();
                Enumeration<URL> e = loader.getResources("META-INF/functions");
                while (e.hasMoreElements()) {
                    URL u = e.nextElement();
                    URLDirectory ud = new URLDirectory(u);
                    ud.list((URLDirectory.URLFilter)cf, loader);
                }
                this.functions = cf.getMap();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public String findStringFunction(String key) {
        this.buildMap();
        Map func = this.functions.get(key);
        String f = (String)func.get("code");
        if (f == null) {
            throw new RuntimeException("Function " + key + " not found");
        }
        return f;
    }

    public Map getFunctionInfo(String key) {
        this.buildMap();
        Map func = this.functions.get(key);
        if (func == null) {
            throw new RuntimeException("Function " + key + " not found");
        }
        return func;
    }

    public List<Map> getAllFunctions(String n) {
        return this.getFunctionsByGroup(null);
    }

    public List<Map> getFunctionsByGroup(String n) {
        this.buildMap();
        LinkedList<Map> list = new LinkedList<Map>();
        for (Map map : this.functions.values()) {
            if (n != null && !n.equalsIgnoreCase(map.get("group") + "")) continue;
            list.add(map);
        }
        return list;
    }

    private class CustomFilter
    implements URLDirectory.URLFilter {
        private Map map = new LinkedHashMap();

        private CustomFilter() {
        }

        public boolean accept(URL u, String filter) {
            try {
                String name = filter.substring(filter.lastIndexOf("/") + 1);
                String s = StreamUtil.toString((InputStream)u.openStream());
                this.map.put(name, JsonUtil.toMap(s));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return false;
        }

        public Map getMap() {
            return this.map;
        }
    }
}

