/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt.controls;

import com.rameses.filemgmt.controls.IconListPane;
import com.rameses.filemgmt.controls.IconListPaneModel;
import com.rameses.rcp.common.IconListModel;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XIconListPanel
extends IconListPane
implements UIControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private String expression;
    private String handler;
    private String varName;
    private boolean dynamic;
    private Binding binding;
    private String[] depends;
    private int index;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private PropertySupport.PropertyInfo propertyInfo;
    private IconListModel model;
    private ControlProperty property;

    @Override
    protected void afterInitComponent() {
        this.varName = "item";
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void load() {
        if (!this.isDynamic()) {
            this.buildModel();
        }
    }

    public void refresh() {
        if (this.isDynamic()) {
            this.buildModel();
        }
        this.buildItems();
    }

    public void setPropertyInfo(PropertySupport.PropertyInfo propertyInfo) {
        this.propertyInfo = propertyInfo;
    }

    public int getStretchWidth() {
        return this.stretchWidth;
    }

    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    public int getStretchHeight() {
        return this.stretchHeight;
    }

    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare((UIControl)this, (Object)o);
    }

    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    @Override
    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    @Override
    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.getName());
        map.put("index", this.getIndex());
        map.put("dynamic", this.isDynamic());
        map.put("handler", this.getHandler());
        map.put("varName", this.getVarName());
        map.put("visibleWhen", this.getVisibleWhen());
        return map;
    }

    @Override
    public void openItem(Object item) {
        if (this.model != null) {
            this.model.openItem(item);
        }
    }

    @Override
    public boolean removeItem(Object item) {
        if (this.model != null) {
            return this.model.removeItem(item);
        }
        return super.removeItem(item);
    }

    @Override
    public void selectionChanged(Object item, int index) {
        String sname = this.getName();
        Binding binding = this.getBinding();
        if (sname != null && sname.trim().length() > 0 && binding != null) {
            try {
                UIControlUtil.setBeanValue((Binding)binding, (String)sname, (Object)item);
                binding.notifyDepends(sname);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.model != null) {
            this.model.selectionChanged(item, index);
        }
    }

    private void buildModel() {
        Object value = null;
        try {
            value = UIControlUtil.getBeanValue((UIControl)this, (String)this.getHandler());
        }
        catch (Throwable t) {
            System.out.println("[WARN] error getting handler value caused by " + t.getMessage());
        }
        IconListModel newModel = null;
        if (value instanceof IconListModel) {
            newModel = (IconListModel)value;
        } else if (value instanceof List) {
            newModel = new IconListModel((List)value);
        } else {
            System.out.println("[WARN] handler value must be an instanceof IconListModel or List");
        }
        newModel.setProvider(new ProviderImpl());
        IconListModel oldModel = this.model;
        if (oldModel != null) {
            oldModel.setProvider(null);
        }
        this.model = newModel;
    }

    private void buildItems() {
        HashMap param = new HashMap();
        ArrayList items = this.model.fetchList(param);
        if (items == null) {
            items = new ArrayList();
        }
        Object xval = null;
        String expr = this.getExpression();
        if (expr == null || expr.trim().length() == 0) {
            expr = "#{" + this.getVarName() + ".caption}";
        }
        IconListPaneModel pm = new IconListPaneModel();
        for (Object obj : items) {
            if (obj instanceof IconListPaneModel.Item) {
                pm.addItem((IconListPaneModel.Item)obj);
                continue;
            }
            if (obj == null) continue;
            try {
                Object exprBean = this.createExpressionBean(obj);
                xval = UIControlUtil.evaluateExpr((Object)exprBean, (String)expr);
            }
            catch (Throwable e) {
                xval = null;
            }
            pm.addItem(obj, null, xval == null ? " " : xval.toString());
        }
        super.setModel(pm);
    }

    private Object createExpressionBean(Object itemBean) {
        ExprBeanSupport beanSupport = new ExprBeanSupport(this.getBinding().getBean());
        beanSupport.setItem(this.getVarName(), itemBean);
        return beanSupport.createProxy();
    }

    private class ProviderImpl
    implements IconListModel.Provider {
        XIconListPanel root;

        private ProviderImpl() {
            this.root = XIconListPanel.this;
        }

        @Override
        public Binding getBinding() {
            return this.root.getBinding();
        }

        @Override
        public void reload() {
            XIconListPanel.this.buildModel();
            XIconListPanel.this.buildItems();
        }

        @Override
        public void refresh() {
            XIconListPanel.this.buildModel();
            XIconListPanel.this.buildItems();
        }

        @Override
        public Object createItem(Object userObject, Object thumbnail, String title) {
            return new IconListPaneModel.Item(userObject, thumbnail, title);
        }

        @Override
        public int indexOf(Object item) {
            return this.root.getModel().indexOf(item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeItemAt(int index) {
            try {
                boolean bl = this.root.getModel().removeItemAt(index);
                return bl;
            }
            finally {
                int size = this.root.getModel().getSize();
                if (index >= size) {
                    index = size - 1;
                }
                if (index >= 0 && index < size) {
                    this.root.setSelectedIndex(index);
                } else {
                    this.root.clearSelection();
                }
            }
        }
    }
}

