/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt.controls;

import com.rameses.util.Base64Cipher;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;

public class IconListPaneModel
extends AbstractListModel {
    private final Object ITEM_LOCKED = new Object();
    private ArrayList<Item> items = new ArrayList();
    private Conf conf = new Conf();

    public Conf getConf() {
        return this.conf;
    }

    public void setConf(Conf conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        Object object = this.ITEM_LOCKED;
        synchronized (object) {
            return this.items.size();
        }
    }

    @Override
    public Object getElementAt(int index) {
        return this.getItem(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.ITEM_LOCKED;
        synchronized (object) {
            return this.items.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object obj) {
        Object object = this.ITEM_LOCKED;
        synchronized (object) {
            if (obj == null) {
                return -1;
            }
            int size = this.items.size();
            for (int i = 0; i < size; ++i) {
                if (!this.items.get(i).equals(obj)) continue;
                return i;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item getItem(int index) {
        Object object = this.ITEM_LOCKED;
        synchronized (object) {
            try {
                return this.items.get(index);
            }
            catch (IndexOutOfBoundsException oobe) {
                return null;
            }
        }
    }

    public Object getItemObject(int index) {
        Item item = this.getItem(index);
        return item == null ? null : item.getUserObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item addItem(Object userObject, Object thumbnail, String title) {
        Object object = this.ITEM_LOCKED;
        synchronized (object) {
            Item item = new Item(userObject, thumbnail, title);
            this.items.add(item);
            return item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item addItem(Item item) {
        Object object = this.ITEM_LOCKED;
        synchronized (object) {
            if (item == null) {
                return item;
            }
            this.items.add(item);
            return item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeItem(Object obj) {
        Object object = this.ITEM_LOCKED;
        synchronized (object) {
            int idx = this.items.indexOf(obj);
            if (idx < 0) {
                return false;
            }
            if (this.items.remove(obj)) {
                this.fireIntervalRemoved(obj, idx, idx);
                Object[] arr = this.items.toArray();
                for (int i = 0; i < arr.length; ++i) {
                    this.fireContentsChanged(arr[i], i, i);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeItemAt(int index) {
        Object object = this.ITEM_LOCKED;
        synchronized (object) {
            Item item = null;
            try {
                item = this.items.remove(index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (item != null) {
                this.fireIntervalRemoved(item, index, index);
                item = null;
                Object[] arr = this.items.toArray();
                for (int i = 0; i < arr.length; ++i) {
                    this.fireContentsChanged(arr[i], i, i);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataChanged() {
        Object[] arr = null;
        Object object = this.ITEM_LOCKED;
        synchronized (object) {
            arr = this.items.toArray();
        }
        for (int i = 0; i < arr.length; ++i) {
            this.fireContentsChanged(arr[i], i, i);
        }
    }

    public static class Conf {
        private Dimension cellSize = new Dimension(100, 80);
        private boolean showCaption = false;

        public Dimension getCellSize() {
            return this.cellSize;
        }

        public void setCellSize(Dimension cellSize) {
            this.cellSize = cellSize;
        }

        public boolean isShowCaption() {
            return this.showCaption;
        }

        public void setShowCaption(boolean showCaption) {
            this.showCaption = showCaption;
        }
    }

    public static class Item {
        final Object ICON_LOCKED = new Object();
        private String title;
        private Object userObject;
        private Object thumbnail;
        private ImageIcon _icon;

        public Item(Object userObject, Object thumbnail, String title) {
            this.userObject = userObject;
            this.thumbnail = thumbnail;
            this.title = title;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public String getTitle() {
            if (this.title != null) {
                return this.title;
            }
            if (this.userObject != null) {
                return this.userObject.toString();
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (this.userObject == null) {
                return obj == null;
            }
            if (obj == null) {
                return this.userObject == null;
            }
            if (!(obj instanceof Item)) {
                return this.userObject.equals(obj);
            }
            return super.equals(obj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ImageIcon getIcon() {
            Object object = this.ICON_LOCKED;
            synchronized (object) {
                if (this._icon != null) {
                    return this._icon;
                }
                Object source = this.thumbnail;
                if (source instanceof String) {
                    source = new Base64Cipher().decode(source.toString(), false);
                }
                if (source instanceof byte[]) {
                    this._icon = new ImageIcon((byte[])source);
                }
                return this._icon;
            }
        }
    }
}

