/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt.controls;

import com.rameses.filemgmt.controls.IconListPaneModel;
import com.rameses.filemgmt.controls.IconListPaneRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IconListPane
extends JPanel {
    private JListImpl jlist;
    private JScrollPane jsp;
    private IconListPaneModel model;
    private IconListPaneModel.Conf modelConf;

    public IconListPane() {
        this.initComponent();
    }

    private void initComponent() {
        super.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(300, 120));
        this.setOpaque(false);
        this.jlist = new JListImpl();
        this.jlist.setSelectionMode(0);
        this.jlist.setLayoutOrientation(2);
        this.jlist.setVisibleRowCount(-1);
        this.jlist.setCellRenderer(new IconListPaneRenderer());
        this.jsp = new JScrollPane(this.jlist);
        this.jsp.setHorizontalScrollBarPolicy(31);
        this.jsp.setVerticalScrollBarPolicy(20);
        this.add((Component)this.jsp, "Center");
        MouseAdapterImpl ma = new MouseAdapterImpl();
        this.jlist.addMouseListener(ma);
        this.setModel(new IconListPaneModel());
        this.jlist.getSelectionModel().addListSelectionListener(new ListSelectionHandler());
        this.jlist.registerKeyboardAction(new OpenItemAction(), KeyStroke.getKeyStroke(10, 0), 0);
        this.jlist.registerKeyboardAction(new RemoveItemAction(), KeyStroke.getKeyStroke(127, 0), 0);
        this.afterInitComponent();
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    protected IconListPaneModel.Conf getConf() {
        if (this.modelConf == null) {
            this.modelConf = new IconListPaneModel.Conf();
        }
        return this.modelConf;
    }

    public IconListPaneModel getModel() {
        return this.model;
    }

    public void setModel(IconListPaneModel model) {
        model.setConf(this.getConf());
        this.model = model;
        this.jlist.setModel(model);
    }

    public Dimension getCellSize() {
        return this.getConf().getCellSize();
    }

    public void setCellSize(Dimension cellSize) {
        this.getConf().setCellSize(cellSize);
    }

    public boolean isShowCaption() {
        return this.getConf().isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.getConf().setShowCaption(showCaption);
    }

    protected void afterInitComponent() {
    }

    public void openItem(Object item) {
    }

    public boolean removeItem(Object item) {
        return false;
    }

    public void selectionChanged(Object item, int index) {
    }

    public void setSelectedIndex(int index) {
        this.jlist.setSelectedIndex(index);
    }

    public void clearSelection() {
        this.jlist.clearSelection();
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        IconListPane root;

        ListSelectionHandler() {
            this.root = IconListPane.this;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int idx = this.root.jlist.getSelectedIndex();
            Object data = this.root.getModel().getItemObject(idx);
            this.root.selectionChanged(data, idx);
        }
    }

    class RemoveItemAction
    implements ActionListener {
        IconListPane root;

        RemoveItemAction() {
            this.root = IconListPane.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int idx = this.root.jlist.getSelectedIndex();
            if (idx < 0) {
                return;
            }
            Object data = this.root.getModel().getItemObject(idx);
            if (this.root.removeItem(data)) {
                this.root.getModel().removeItemAt(idx);
                int size = this.root.getModel().getSize();
                if (idx >= size) {
                    idx = size - 1;
                }
                if (idx < size) {
                    this.root.jlist.setSelectedIndex(idx);
                }
            }
        }
    }

    class OpenItemAction
    implements ActionListener {
        IconListPane root;

        OpenItemAction() {
            this.root = IconListPane.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int idx = this.root.jlist.getSelectedIndex();
            if (idx < 0) {
                return;
            }
            Object data = this.root.getModel().getItemObject(idx);
            this.root.openItem(data);
        }
    }

    class MouseAdapterImpl
    extends MouseAdapter {
        IconListPane root;

        MouseAdapterImpl() {
            this.root = IconListPane.this;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int idx = IconListPane.this.jlist.locationToIndex(e.getPoint());
                IconListPaneModel.Item item = IconListPane.this.model.getItem(idx);
                if (item != null) {
                    this.root.openItem(item.getUserObject());
                }
            }
        }
    }

    class JListImpl
    extends JList {
        IconListPane root;

        JListImpl() {
            this.root = IconListPane.this;
        }

        @Override
        public void setSelectedIndex(int index) {
            super.setSelectedIndex(index);
        }
    }
}

