/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt.components;

import com.rameses.common.MethodResolver;
import com.rameses.common.PropertyResolver;
import com.rameses.filemgmt.components.SplitterPanel;
import com.rameses.filemgmt.components.ThumbnailViewPanel;
import com.rameses.rcp.common.ComponentBean;
import com.rameses.rcp.common.FileViewModel;
import com.rameses.rcp.control.XButton;
import com.rameses.rcp.control.XComponentPanel;
import com.rameses.rcp.control.XLabel;
import com.rameses.rcp.control.XList;
import com.rameses.rcp.control.XPanel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

@com.rameses.rcp.ui.annotations.ComponentBean(value="com.rameses.filemgmt.components.FileViewPanelModel")
public class FileViewPanel
extends XComponentPanel {
    private String items;
    private String handler;
    private String allowAddWhen;
    private String allowRemoveWhen;
    private String editableWhen;
    private HeaderPanel headerPanel;
    private SplitterPanel splitPanel;
    private FileViewModel modelHandler;
    private ThumbnailViewPanel viewPanel;
    private Dimension cellSize;
    private int cellSpacing;

    public FileViewPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new MainLayoutManager());
        this.setPreferredSize(new Dimension(200, 100));
        this.modelHandler = new FileViewModelImpl(null);
        this.headerPanel = new HeaderPanel();
        this.splitPanel = new SplitterPanel();
        this.add("header", this.headerPanel);
        this.add("content", this.splitPanel);
        XList xlist = new XList();
        xlist.setName("selectedItem");
        xlist.setHandler("listHandler");
        xlist.setExpression("#{item.title}");
        xlist.setFixedCellHeight(20);
        JScrollPane jsp = new JScrollPane((Component)xlist);
        jsp.setHorizontalScrollBarPolicy(30);
        jsp.setVerticalScrollBarPolicy(20);
        this.splitPanel.setSideView(jsp);
        XPanel cardpanel = new XPanel();
        cardpanel.setLayout((LayoutManager)new CardLayout());
        cardpanel.setDepends(new String[]{"selectedItem"});
        cardpanel.setName("cardName");
        XLabel loadComp = new XLabel();
        loadComp.setHorizontalAlignment(0);
        loadComp.setDepends(new String[]{"selectedItem"});
        loadComp.setIconResource("com/rameses/rcp/icons/loading32.gif");
        loadComp.setVisibleWhen("#{cardName == 'loading'}");
        cardpanel.add((Component)loadComp, (Object)"loading");
        XLabel blankComp = new XLabel();
        blankComp.setHorizontalAlignment(0);
        blankComp.setVerticalAlignment(1);
        blankComp.setText("<html><br/><h3>No available item(s)</h3></html>");
        blankComp.setForeground(Color.decode("#a0a0a0"));
        blankComp.setVisibleWhen("#{cardName == 'blank'}");
        blankComp.setDepends(new String[]{"selectedItem"});
        blankComp.setOpaque(true);
        cardpanel.add((Component)blankComp, (Object)"blank");
        Color borderColor = new Color(150, 150, 150);
        loadComp.setBorder(BorderFactory.createLineBorder(borderColor, 1));
        blankComp.setBorder(BorderFactory.createLineBorder(borderColor, 1));
        this.viewPanel = new ThumbnailViewPanel();
        this.viewPanel.setName("selectedThumbnail");
        this.viewPanel.setHandler("thumbnailListHandler");
        this.viewPanel.setDepends(new String[]{"selectedItem"});
        this.viewPanel.setVisibleWhen("#{cardName == 'view'}");
        this.viewPanel.setCellSize(new Dimension(100, 80));
        cardpanel.add((Component)((Object)this.viewPanel), (Object)"view");
        XPanel headerpanel = new XPanel();
        headerpanel.setLayout((LayoutManager)new BorderLayout());
        headerpanel.setDepends(new String[]{"selectedItem"});
        XPanel contentview = new XPanel();
        this.splitPanel.setContentView((Component)contentview);
        contentview.setLayout((LayoutManager)new BorderLayout());
        contentview.add("North", (Component)headerpanel);
        contentview.add((Component)cardpanel);
        Border bout = BorderFactory.createLineBorder(borderColor, 1);
        Border bin = BorderFactory.createEmptyBorder(3, 5, 3, 5);
        XLabel headerinfo = new XLabel();
        headerinfo.setBorder((Border)BorderFactory.createCompoundBorder(bout, bin));
        headerinfo.setVerticalAlignment(1);
        headerinfo.setMinimumSize(new Dimension(100, 30));
        headerinfo.setBackground(Color.WHITE);
        headerinfo.setOpaque(true);
        headerinfo.setText("Header Message");
        headerinfo.setExpression("#{headerMessage}");
        headerinfo.setDepends(new String[]{"selectedItem"});
        headerpanel.add("North", (Component)headerinfo);
        headerpanel.add("South", Box.createVerticalStrut(5));
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getItems() {
        return this.items;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public int getDividerSize() {
        return this.splitPanel == null ? 0 : this.splitPanel.getDividerSize();
    }

    public void setDividerSize(int dividerSize) {
        if (this.splitPanel != null) {
            this.splitPanel.setDividerSize(dividerSize);
        }
    }

    public int getDividerLocation() {
        return this.splitPanel == null ? 0 : this.splitPanel.getDividerLocation();
    }

    public void setDividerLocation(int dividerLocation) {
        if (this.splitPanel != null) {
            this.splitPanel.setDividerLocation(dividerLocation);
        }
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(Dimension cellSize) {
        this.cellSize = cellSize;
        if (this.viewPanel != null) {
            this.viewPanel.setCellSize(this.cellSize);
        }
    }

    public int getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(int cellSpacing) {
        this.cellSpacing = cellSpacing;
        if (this.viewPanel != null) {
            this.viewPanel.setCellSpacing(this.cellSpacing);
        }
    }

    public String getAllowAddWhen() {
        return this.allowAddWhen;
    }

    public void setAllowAddWhen(String allowAddWhen) {
        this.allowAddWhen = allowAddWhen;
    }

    public String getAllowRemoveWhen() {
        return this.allowRemoveWhen;
    }

    public void setAllowRemoveWhen(String allowRemoveWhen) {
        this.allowRemoveWhen = allowRemoveWhen;
    }

    public String getEditableWhen() {
        return this.editableWhen;
    }

    public void setEditableWhen(String editableWhen) {
        this.editableWhen = editableWhen;
    }

    protected void initComponentBean(ComponentBean bean) {
        Dimension dim;
        Number num;
        Object caller;
        Object oval;
        Object caller2;
        Object oval2;
        PropertyResolver pr = PropertyResolver.getInstance();
        FileViewModel newhandler = null;
        String shandler = this.getHandler();
        if (shandler != null && shandler.trim().length() > 0 && (oval2 = pr.getProperty(caller2 = this.getBean(), shandler)) instanceof FileViewModel) {
            newhandler = (FileViewModel)oval2;
        }
        String items = this.getItems();
        if (newhandler == null && items != null && items.trim().length() > 0 && (oval = pr.getProperty(caller = this.getBean(), items)) instanceof List) {
            newhandler = new FileViewModelImpl((List)oval);
        }
        if (newhandler == null) {
            newhandler = new FileViewModelImpl(null);
        }
        if ((num = newhandler.getCellSpacing()) != null) {
            this.viewPanel.setCellSpacing(num.intValue());
        }
        if ((dim = this.viewPanel.getCellSize()) == null) {
            dim = this.viewPanel.getDefaultCellSize();
        }
        Number nw = newhandler.getCellWidth();
        Number nh = newhandler.getCellHeight();
        Dimension newdim = new Dimension(dim.width, dim.height);
        if (nw != null) {
            newdim.width = nw.intValue();
        }
        if (nh != null) {
            newdim.height = nh.intValue();
        }
        this.viewPanel.setCellSize(newdim);
        this.viewPanel.setMultiSelect(newhandler.isMultiSelect());
        newhandler.setProvider(new FileViewModelProvider());
        this.modelHandler = newhandler;
        pr.setProperty((Object)bean, "handlerProxy", (Object)this.modelHandler);
        pr.setProperty((Object)bean, "name", (Object)this.getName());
        Object albumHandler = pr.getProperty((Object)bean, "listHandler");
        this.modelHandler.getWorkspace().setAlbumHandler(albumHandler);
    }

    public void afterLoad() {
        super.afterLoad();
    }

    public void refresh() {
        boolean bool = this.getExprValue(this.getBean(), this.getEditableWhen(), true);
        this.modelHandler.setEditable(bool);
        bool = this.getExprValue(this.getBean(), this.getAllowAddWhen(), true);
        this.modelHandler.setAllowAdd(bool);
        bool = this.getExprValue(this.getBean(), this.getAllowRemoveWhen(), true);
        this.modelHandler.setAllowRemove(bool);
        if (this.headerPanel != null) {
            this.headerPanel.setEditable(this.modelHandler.isEditable());
        }
        super.refresh();
    }

    private boolean getExprValue(Object bean, String expr, boolean defaultValue) {
        if (expr != null && expr.trim().length() > 0) {
            try {
                return UIControlUtil.evaluateExprBoolean((Object)this.getBean(), (String)expr);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private class HeaderPanelLayout
    implements LayoutManager {
        private Component label;
        private Component btn1;
        private Component btn2;

        private HeaderPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name != null && comp != null) {
                if ("label".equals(name)) {
                    this.label = comp;
                } else if ("btn1".equals(name)) {
                    this.btn1 = comp;
                } else if ("btn2".equals(name)) {
                    this.btn2 = comp;
                }
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp != null) {
                if (this.label != null && this.label.equals(comp)) {
                    this.label = null;
                } else if (this.btn1 != null && this.btn1.equals(comp)) {
                    this.btn1 = null;
                } else if (this.btn2 != null && this.btn2.equals(comp)) {
                    this.btn2 = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        private Dimension getLayoutSize(Container parent) {
            int w = 0;
            int h = 0;
            int flag = 0;
            Component[] comps = new Component[]{this.label, this.btn1, this.btn2};
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] == null || !comps[i].isVisible()) continue;
                Dimension dim = comps[i].getPreferredSize();
                if (flag > 0) {
                    ++w;
                }
                w += dim.width;
                h = Math.max(h, dim.height);
                flag = 1;
            }
            Insets margin = parent.getInsets();
            return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int w = parent.getWidth() - (margin.left + margin.right);
                int h = parent.getHeight() - (margin.top + margin.bottom);
                int rPos = parent.getWidth() - margin.right;
                Component[] comps = new Component[]{this.label, this.btn1, this.btn2};
                for (int i = 0; i < comps.length; ++i) {
                    if (comps[i] == null || !comps[i].isVisible()) continue;
                    Dimension dim = comps[i].getPreferredSize();
                    comps[i].setBounds(x, y, dim.width, h);
                    x += dim.width;
                }
            }
        }
    }

    private class HeaderPanel
    extends JPanel {
        FileViewPanel root;
        private XLabel label;
        private XButton btn1;
        private XButton btn2;

        HeaderPanel() {
            this.root = FileViewPanel.this;
            this.setLayout(new HeaderPanelLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.label = new XLabel();
            this.label.setExpression("<b>Attachments</b>");
            this.label.setFontStyle("font-weight:bold; font-size:12;");
            this.label.setForeground(Color.decode("#505050"));
            this.label.setUseHtml(true);
            this.label.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 20));
            this.add("label", (Component)this.label);
            this.btn1 = new XButton();
            this.btn1.setMargin(new Insets(2, 2, 2, 2));
            this.btn1.setText("");
            this.btn1.setName("addFile");
            this.btn1.setToolTipText("Attach File(s)");
            this.btn1.setContentAreaFilled(false);
            this.btn1.setDisableWhen("#{allowAddPermitted != true}");
            this.btn1.setVisibleWhen("#{allowAddPermitted == true}");
            this.btn1.setIconResource("com/rameses/filemgmt/images/attachment-16.png");
            this.add("btn1", (Component)this.btn1);
            this.btn2 = new XButton();
            this.btn2.setMargin(new Insets(2, 2, 2, 2));
            this.btn2.setText("");
            this.btn2.setName("removeFile");
            this.btn2.setToolTipText("Remove Selected Attachment");
            this.btn2.setContentAreaFilled(false);
            this.btn2.setDepends(new String[]{"selectedItem"});
            this.btn2.setDisableWhen("#{allowRemovePermitted != true}");
            this.btn2.setVisibleWhen("#{allowRemovePermitted == true}");
            this.btn2.setIconResource("com/rameses/filemgmt/images/recyclebin-16.png");
            this.add("btn2", (Component)this.btn2);
        }

        void setEditable(boolean editable) {
            this.btn1.setVisible(editable);
            this.btn2.setVisible(editable);
        }
    }

    private class MainLayoutManager
    implements LayoutManager {
        private Component header;
        private Component content;
        private Component footer;

        private MainLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (name != null && comp != null) {
                if ("header".equals(name)) {
                    this.header = comp;
                } else if ("content".equals(name)) {
                    this.content = comp;
                } else if ("footer".equals(name)) {
                    this.footer = comp;
                }
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp != null) {
                if (this.header != null && this.header.equals(comp)) {
                    this.header = null;
                } else if (this.content != null && this.content.equals(comp)) {
                    this.content = null;
                } else if (this.footer != null && this.footer.equals(comp)) {
                    this.footer = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return this.getLayoutSize(parent);
            }
        }

        private Dimension getLayoutSize(Container parent) {
            int w = 0;
            int h = 0;
            Component[] comps = new Component[]{this.header, this.content, this.footer};
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] == null || !comps[i].isVisible()) continue;
                Dimension dim = comps[i].getPreferredSize();
                w = Math.max(w, dim.width);
                h += dim.height;
            }
            Insets margin = parent.getInsets();
            return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                int topY = margin.top;
                if (this.header != null && this.header.isVisible()) {
                    Dimension dim = this.header.getPreferredSize();
                    this.header.setBounds(x, topY, w, dim.height);
                    topY += dim.height;
                }
                int botY = ph - margin.bottom;
                if (this.footer != null && this.footer.isVisible()) {
                    Dimension dim = this.footer.getPreferredSize();
                    this.footer.setBounds(x, botY -= dim.height, w, dim.height);
                }
                if (this.content != null && this.content.isVisible()) {
                    int ch = Math.max(botY - topY, 0);
                    this.content.setBounds(x, topY, w, ch);
                }
            }
        }
    }

    private class FileViewModelProvider
    implements FileViewModel.Provider {
        FileViewPanel root;

        private FileViewModelProvider() {
            this.root = FileViewPanel.this;
        }

        @Override
        public Binding getBinding() {
            return this.root.getBinding();
        }

        @Override
        public Binding getInnerBinding() {
            return this.root.getInnerBinding();
        }

        @Override
        public void addItem(Object item) throws Exception {
            Object bean = this.root.getInnerBinding().getBean();
            MethodResolver.getInstance().invoke(bean, "addItem", new Object[]{item});
            this.root.modelHandler.afterAddItem(item);
        }

        @Override
        public void updateBeanValue() {
            Object bean;
            String sname = this.root.getName();
            if (sname == null || sname.trim().length() == 0) {
                return;
            }
            Binding binding = this.getBinding();
            Object object = bean = binding == null ? null : binding.getBean();
            if (bean == null) {
                return;
            }
            Object value = null;
            UIControlUtil.setBeanValue((Object)bean, (String)sname, value);
            binding.notifyDepends(sname);
        }
    }

    private class FileViewModelImpl
    extends FileViewModel {
        private List items;

        FileViewModelImpl(List items) {
            this.items = items;
        }

        @Override
        public List fetchList(Map params) {
            return this.items;
        }

        @Override
        public boolean removeItem(Object item) {
            if (item == null) {
                return false;
            }
            if (this.items == null || this.items.isEmpty()) {
                return false;
            }
            return this.items.remove(item);
        }

        @Override
        public void afterAddItem(Object item) {
            if (this.items != null) {
                this.items.add(item);
            }
        }
    }
}

