/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt;

import java.util.Map;

final class FileLocationConf {
    private String name;
    private String type;
    private String url;
    private String rootdir;
    private String username;
    private String password;
    private boolean defaulted;
    private Map properties;

    FileLocationConf(Map data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        this.properties = data;
        this.name = this.getProperty(data, "name");
        this.type = this.getProperty(data, "type");
        this.url = this.getProperty(data, "url");
        this.rootdir = this.getProperty(data, "rootdir");
        this.username = this.getProperty(data, "username");
        this.password = this.getProperty(data, "password");
        this.defaulted = (this.getProperty(data, "defaulted") + "").matches("true|1");
    }

    public boolean isDefaulted() {
        return this.defaulted;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getRootDir() {
        return this.rootdir;
    }

    public String getUser() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    private String getProperty(Map data, String name) {
        Object value = data == null ? null : (Object)data.get(name);
        return value == null ? null : value.toString();
    }
}

