/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.filemgmt;

import com.rameses.filemgmt.FileLocationConf;
import com.rameses.filemgmt.FileLocationRegistry;
import com.rameses.ftp.FtpLocationConf;
import com.rameses.ftp.FtpManager;
import com.rameses.ftp.FtpSession;
import com.rameses.io.FileLocTypeProvider;
import com.rameses.io.FileTransferSession;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class FTPLocTypeProvider
implements FileLocTypeProvider,
FileLocationRegistry {
    private static final String PROVIDER_NAME = "ftp";

    public String getName() {
        return PROVIDER_NAME;
    }

    public FileTransferSession createUploadSession() {
        return new UploadSession();
    }

    public FileTransferSession createDownloadSession() {
        return new DownloadSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String name, String locationConfigId) {
        FtpSession sess = null;
        try {
            sess = FtpManager.createSession((String)locationConfigId);
            sess.deleteFile(name);
        }
        catch (Throwable t) {
            System.out.println("[FTPLocTypeProvider] delete file error: " + t.getMessage());
        }
        finally {
            try {
                sess.disconnect();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void register(FileLocationConf conf) {
        if (conf == null) {
            return;
        }
        if (PROVIDER_NAME.equals(conf.getType())) {
            FtpLocationConf ftpc = FtpLocationConf.add((String)conf.getName());
            ftpc.setHost(conf.getUrl());
            ftpc.setUser(conf.getUser());
            ftpc.setPassword(conf.getPassword());
            ftpc.setRootDir(conf.getRootDir());
        }
    }

    private class DownloadSession
    extends FileTransferSession
    implements FtpSession.Handler {
        private FtpSession sess;

        private DownloadSession() {
        }

        public void cancel() {
            super.cancel();
            if (this.isCancelled()) {
                this.disconnect();
            }
        }

        public void run() {
            if (this.isCancelled()) {
                this.disconnect();
                return;
            }
            this.sess = FtpManager.createSession((String)this.getLocationConfigId());
            this.sess.setBufferSize(102400);
            this.sess.setHandler((FtpSession.Handler)this);
            OutputStream out = this.getOutputStream();
            if (out == null) {
                this.sess.download(this.getTargetName(), this.getFile());
            } else if (out instanceof ByteArrayOutputStream) {
                this.sess.download(this.getTargetName(), (ByteArrayOutputStream)out);
            }
            this.disconnect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void disconnect() {
            try {
                this.sess.disconnect();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.sess = null;
            }
        }

        public void onTransfer(long filesize, long bytesprocessed) {
        }

        public void onTransfer(long bytesprocessed) {
            FileTransferSession.Handler handler = this.getHandler();
            if (handler == null) {
                return;
            }
            handler.ontransfer(bytesprocessed);
        }

        public void onComplete() {
            FileTransferSession.Handler handler = this.getHandler();
            if (handler == null) {
                return;
            }
            handler.oncomplete();
        }
    }

    private class UploadSession
    extends FileTransferSession
    implements FtpSession.Handler {
        private FtpSession sess;

        private UploadSession() {
        }

        public void cancel() {
            super.cancel();
            if (this.isCancelled()) {
                this.disconnect();
            }
        }

        public void run() {
            if (this.isCancelled()) {
                this.disconnect();
                return;
            }
            this.sess = FtpManager.createSession((String)this.getLocationConfigId());
            this.sess.setBufferSize(102400);
            this.sess.setHandler((FtpSession.Handler)this);
            this.sess.upload(this.getTargetName(), this.getFile(), this.getOffset());
            this.disconnect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void disconnect() {
            try {
                this.sess.disconnect();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.sess = null;
            }
        }

        public void onTransfer(long filesize, long bytesprocessed) {
            FileTransferSession.Handler handler = this.getHandler();
            if (handler == null) {
                return;
            }
            handler.ontransfer(filesize, bytesprocessed);
        }

        public void onTransfer(long bytesprocessed) {
        }

        public void onComplete() {
            FileTransferSession.Handler handler = this.getHandler();
            if (handler == null) {
                return;
            }
            handler.oncomplete();
        }
    }
}

