/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.classutils.AnnotationFieldHandler;
import com.rameses.classutils.ClassDefUtil;
import com.rameses.osiris2.client.FieldInjectionHandler;
import com.rameses.osiris2.client.OsirisContext;
import com.rameses.rcp.framework.ClientContext;
import groovy.lang.GroovyClassLoader;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;

public final class ScriptProvider {
    private static ScriptProvider instance;
    private AnnotationFieldHandler fieldHandler = new FieldInjectionHandler();
    private GroovyClassLoader loader;
    private Map<String, Class> scriptMap = new Hashtable<String, Class>();

    public ScriptProvider() {
        this.loader = new GroovyClassLoader(ClientContext.getCurrentContext().getClassLoader());
    }

    public static ScriptProvider getInstance() {
        if (instance == null) {
            instance = new ScriptProvider();
        }
        return instance;
    }

    public Object create(String name) throws Exception {
        String nameSpace = null;
        String scriptName = name;
        if (name.indexOf(":") > 0) {
            nameSpace = name.substring(0, name.indexOf(":"));
            scriptName = name.substring(name.indexOf(":") + 1);
        }
        scriptName = scriptName.replaceAll("\\.", "/");
        if (!this.scriptMap.containsKey(name)) {
            String fileName = "META-INF/scripts/" + scriptName;
            InputStream is = null;
            try {
                is = nameSpace == null ? this.loader.getResourceAsStream(fileName) : OsirisContext.getSession().getModule(nameSpace).getResourceAsStream(fileName);
                if (is == null) {
                    throw new RuntimeException("Cannot find script " + name + ".");
                }
                Class clazz = this.loader.parseClass(is, scriptName);
                this.scriptMap.put(name, clazz);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            Class clazz = this.scriptMap.get(name);
            Object obj = clazz.newInstance();
            ClassDefUtil.getInstance().injectFields(obj, this.fieldHandler);
            return obj;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

