/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.common.AsyncHandler;
import com.rameses.osiris2.client.OsirisContext;
import com.rameses.service.ScriptServiceContext;
import com.rameses.service.ServiceProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;

public class OsirisInvokerHandler
implements InvocationHandler {
    private String serviceName;
    private Map appEnv;
    private ServiceProxy proxy;

    public OsirisInvokerHandler(String serviceName, Map appEnv) {
        this.serviceName = serviceName;
        this.appEnv = appEnv;
        ScriptServiceContext sc = new ScriptServiceContext(appEnv);
        Map clientEnv = OsirisContext.getEnv();
        this.proxy = (ServiceProxy)sc.create(serviceName, clientEnv);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] xargs) throws Throwable {
        if (method.getName().equals("toString")) {
            return this.serviceName;
        }
        try {
            Object lastArg;
            AsyncHandler handler = null;
            Object[] args = xargs;
            if (args != null && args.length > 0 && (lastArg = args[args.length - 1]) instanceof AsyncHandler) {
                handler = (AsyncHandler)lastArg;
                Object[] mlist = new Object[args.length - 1];
                for (int j = 0; j < mlist.length; ++j) {
                    mlist[j] = args[j];
                }
                args = mlist;
            }
            Object o = this.proxy.invoke(method.getName(), args);
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

