/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2;

import com.rameses.osiris2.CodeProvider;
import com.rameses.osiris2.Module;
import com.rameses.osiris2.ModuleContext;
import com.rameses.osiris2.Page;
import com.rameses.osiris2.WorkUnitInstance;
import com.rameses.osiris2.flow.PageFlow;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class WorkUnit
implements Serializable {
    private String name;
    private Module module;
    private String sid;
    private PageFlow pageFlow;
    private String title;
    private String codeSource;
    private Class sourceClass;
    private String className;
    private Page defaultPage;
    private Map pages = new Hashtable();
    private Map properties = new HashMap();

    public WorkUnit() {
    }

    public WorkUnit(String name, Module module) {
        if (name == null) {
            throw new IllegalArgumentException("WokUnit name must be provided");
        }
        if (module == null) {
            throw new IllegalArgumentException("WorkUnit module must be provided");
        }
        this.name = name;
        this.module = module;
        this.sid = module.getNamespace() + ":" + name;
    }

    public String getId() {
        return this.sid;
    }

    public String getName() {
        return this.name;
    }

    public Module getModule() {
        return this.module;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map getPages() {
        return this.pages;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Page getDefaultPage() {
        return this.defaultPage;
    }

    public PageFlow getPageFlow() {
        return this.pageFlow;
    }

    public void setPageFlow(PageFlow pageFlow) {
        this.pageFlow = pageFlow;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setCodeSource(String codeSource) {
        this.codeSource = codeSource;
    }

    public void addPage(Page page) {
        if (page.getName() == null || page.getName().length() == 0 || page.getName().equals("default")) {
            page.setName("default");
            this.defaultPage = page;
        }
        this.pages.put(page.getName(), page);
        if (this.defaultPage == null) {
            this.defaultPage = page;
        }
    }

    public void destroy() {
        this.getPages().clear();
        this.pages = null;
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<workunit>");
        if (this.codeSource != null) {
            sb.append("<code>");
            sb.append(this.codeSource);
            sb.append("</code>");
        }
        if (this.getPages().size() > 0) {
            sb.append("<pages>");
            Iterator iter = this.getPages().values().iterator();
            while (iter.hasNext()) {
                sb.append(((Page)iter.next()).toXml());
            }
            sb.append("</pages>");
        }
        sb.append("</workunit>");
        if (this.getPageFlow() != null) {
            sb.append("<pageflow>");
            sb.append(this.getPageFlow().toString());
            sb.append("</pageflow>");
        }
        sb.append("</workunit>");
        return sb.toString();
    }

    public WorkUnitInstance newInstance() {
        return new WorkUnitInstance(this);
    }

    public WorkUnitInstance newInstance(String id, String title) {
        WorkUnitInstance wi = new WorkUnitInstance(this);
        wi.setId(id);
        wi.setTitle(title);
        return wi;
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof WorkUnit)) {
            return false;
        }
        WorkUnit w = (WorkUnit)object;
        return this.getId().equals(w.getId());
    }

    public Object getCodeInstance() {
        try {
            ModuleContext.set(this.module);
            CodeProvider provider = this.module.getAppContext().getCodeProvider();
            if (this.codeSource != null && this.codeSource.trim().length() > 0) {
                if (this.sourceClass == null) {
                    this.sourceClass = provider.createClass(this.codeSource);
                }
                if (this.sourceClass != null) {
                    Object object = provider.createObject(this.sourceClass);
                    return object;
                }
            } else if (this.className != null) {
                if (this.sourceClass == null) {
                    this.sourceClass = provider.loadClass(this.className);
                }
                if (this.sourceClass != null) {
                    Object object = provider.createObject(this.sourceClass);
                    return object;
                }
            }
            try {
                throw new Exception("Code Source or Class Name must be provided in workunit.code");
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        finally {
            ModuleContext.remove();
        }
    }
}

