/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2;

import com.rameses.osiris2.AppContext;
import com.rameses.osiris2.EnvMap;
import com.rameses.osiris2.Folder;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.InvokerSource;
import com.rameses.osiris2.Module;
import com.rameses.osiris2.SecurityProvider;
import com.rameses.osiris2.WorkUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SessionContext {
    public static final Pattern EXT_PERM_PATTERN = Pattern.compile("(?:(.*):)?[^\\.]*\\.[^\\.]*$");
    private AppContext context;
    private Map env = new EnvMap();
    private SecurityProvider securityProvider;
    protected Map folderIndex = new Hashtable();
    protected Map invokers = new Hashtable();
    private Map properties = new Hashtable();

    protected SessionContext(AppContext ctx) {
        this.context = ctx;
        this.env = new EnvMap(ctx.getEnv());
        this.env.put("CLIENTTYPE", "desktop");
    }

    public Map getEnv() {
        return this.env;
    }

    public Module getModule(String name) {
        Module c = this.context.getModule(name);
        if (c == null) {
            throw new IllegalStateException("Module not found : " + name);
        }
        return c;
    }

    public WorkUnit getWorkUnit(String name) {
        return this.context.getWorkUnit(name);
    }

    public boolean checkPermission(String domain, String role, String name) {
        if (role == null && name == null) {
            return true;
        }
        return this.securityProvider.checkPermission(domain, role, name);
    }

    public List getInvokers() {
        return this.getInvokers(null);
    }

    public List getInvokers(String type) {
        return this.getInvokers(type, true);
    }

    public boolean checkInvoker(Invoker inv) {
        return true;
    }

    public List getInvokers(String type, boolean applySecurity) {
        if (type == null) {
            type = "folder";
        }
        if (!this.invokers.containsKey(type)) {
            ArrayList<Invoker> list = new ArrayList<Invoker>();
            ArrayList removals = new ArrayList();
            for (Invoker inv : this.context.getInvokers()) {
                String itype;
                String string = itype = inv.getType() == null ? "folder" : inv.getType();
                if (!itype.matches(type) && !itype.equalsIgnoreCase(type)) continue;
                boolean showIt = true;
                String permission = inv.getPermission();
                String role = inv.getRole();
                String domain = inv.getDomain();
                if (applySecurity) {
                    List<Invoker.Action> actions;
                    if (role != null || permission != null) {
                        showIt = this.checkPermission(domain, role, permission);
                    }
                    if (showIt && !(actions = inv.getActions()).isEmpty()) {
                        boolean foundIt = false;
                        for (Invoker.Action ia : actions) {
                            String aperm;
                            String aname = ia.getName();
                            String arole = ia.getRole();
                            if (!this.checkPermission(domain, arole, aperm = ia.getPermission())) continue;
                            ia.update(inv);
                            foundIt = true;
                            break;
                        }
                        showIt = foundIt;
                    }
                }
                if (showIt) {
                    showIt = this.checkInvoker(inv);
                }
                if (!showIt) continue;
                list.add(inv);
            }
            Collections.sort(list);
            this.invokers.put(type, list);
            return list;
        }
        return (List)this.invokers.get(type);
    }

    public final List<Invoker> getInvokersByWorkunitid(String id) {
        ArrayList<Invoker> list = new ArrayList<Invoker>();
        if (id == null || id.length() == 0) {
            return list;
        }
        for (Invoker inv : this.context.getInvokers()) {
            if (!id.equals(inv.getWorkunitid())) continue;
            list.add(inv);
        }
        Collections.sort(list);
        return list;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public List getFolders(String name) {
        return this.getFolders(name, null);
    }

    public List getFolders(Folder parent) {
        return this.getFolders(parent, null);
    }

    public List getFolders(String name, InvokerSource invokerSrc) {
        Folder folder;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((folder = (Folder)this.context.getFolderManager().getFolders().get(name)) == null) {
            return null;
        }
        return this.getFolders(folder, invokerSrc);
    }

    public List getFolders(Folder parent, InvokerSource invokerSrc) {
        String fullId = parent.getFullId();
        List<Folder> list = null;
        if (this.folderIndex.get(fullId) == null) {
            list = new ArrayList();
            Iterator iter = parent.getFolders().iterator();
            while (iter.hasNext()) {
                list.add((Folder)iter.next());
            }
            List invokers = this.getInvokers("folder");
            if (invokerSrc != null) {
                invokers.addAll(invokerSrc.getInvokers("folder"));
            }
            for (Invoker inv : invokers) {
                String fname;
                String fid = (String)inv.getProperties().get("folderid");
                if (fid == null) continue;
                if (!fid.startsWith("/")) {
                    fid = "/" + fid;
                }
                if (!fid.equals(parent.getFullId())) continue;
                if (inv.getName() == null) {
                    inv.setName(fid);
                }
                if ((fname = inv.getName()) == null) continue;
                Folder f = new Folder(fname, inv.getCaption(), parent, inv);
                list.add(f);
            }
            this.sortFolders(list);
            this.folderIndex.put(fullId, list);
        } else {
            list = (List)this.folderIndex.get(fullId);
        }
        return list;
    }

    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    public Map getProperties() {
        return this.properties;
    }

    private void sortFolders(List list) {
        ArrayList<FolderGroup> groups = new ArrayList<FolderGroup>();
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (!(o instanceof Folder)) continue;
            Folder f = (Folder)o;
            int findex = f.getIndex() == null ? 0 : f.getIndex();
            FolderGroup g = this.findFolderGroup(groups, findex);
            if (g == null) {
                g = new FolderGroup(findex);
                groups.add(g);
            }
            g.add(f);
        }
        Collections.sort(groups);
        ArrayList target = new ArrayList();
        for (FolderGroup g : groups) {
            g.sortItems();
            g.copyItemsTo(target);
            g.clear();
        }
        list.clear();
        list.addAll(target);
        target.clear();
    }

    private FolderGroup findFolderGroup(List<FolderGroup> groups, int key) {
        for (FolderGroup g : groups) {
            if (g == null || g.index != key) continue;
            return g;
        }
        return null;
    }

    private class FolderGroup
    implements Comparable {
        private int index;
        private List folders;

        FolderGroup(int index) {
            this.index = index;
            this.folders = new ArrayList();
        }

        public boolean equals(Object obj) {
            if (obj instanceof FolderGroup) {
                return ((FolderGroup)obj).index == this.index;
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue() == this.index;
            }
            return super.equals(obj);
        }

        public int compareTo(Object o) {
            if (o instanceof FolderGroup) {
                FolderGroup g = (FolderGroup)o;
                if (this.index < g.index) {
                    return -1;
                }
                if (this.index > g.index) {
                    return 1;
                }
                return 0;
            }
            return 999999999;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString()).append(" ( ");
            sb.append("index=" + this.index).append(", ");
            sb.append("size=" + this.folders.size()).append(" ) ");
            return sb.toString();
        }

        void add(Object o) {
            if (!this.folders.contains(o)) {
                this.folders.add(o);
            }
        }

        void copyItemsTo(List target) {
            for (Object o : this.folders) {
                if (o == null || target.contains(o)) continue;
                target.add(o);
            }
        }

        void sortItems() {
            Collections.sort(this.folders, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s2;
                    Folder f1 = (Folder)o1;
                    Folder f2 = (Folder)o2;
                    Invoker inv1 = f1.getInvoker();
                    Invoker inv2 = f2.getInvoker();
                    String s1 = inv1 == null ? f1.getCaption() : inv1.getCaption();
                    String string = s2 = inv2 == null ? f2.getCaption() : inv2.getCaption();
                    if (s1 == null) {
                        s1 = "";
                    }
                    if (s2 == null) {
                        s2 = "";
                    }
                    return s1.toLowerCase().compareTo(s2.toLowerCase());
                }
            });
        }

        void clear() {
            this.folders.clear();
        }
    }
}

