/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2;

import com.rameses.osiris2.AppContext;
import com.rameses.osiris2.Folder;
import com.rameses.util.ValueUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;

public class FolderManager
implements Serializable {
    private Map folders = new Hashtable();
    private AppContext appContext;

    FolderManager(AppContext app) {
        this.appContext = app;
    }

    public Map getFolders() {
        return this.folders;
    }

    public Folder addFolder(Folder folder, Folder parent) {
        String fullId = folder.getId();
        if (fullId == null) {
            throw new IllegalStateException("Error adding folder. Folder must have an Id!");
        }
        if (!fullId.startsWith("/")) {
            fullId = "/" + fullId;
        }
        if (parent != null) {
            fullId = parent.getFullId() + "/" + folder.getId();
        }
        if (!this.folders.containsKey(fullId)) {
            folder.setFullId(fullId);
            this.folders.put(folder.getFullId(), folder);
            if (parent != null) {
                parent.getFolders().add(folder);
                folder.setParent(parent);
                Collections.sort(parent.getFolders());
            }
            return folder;
        }
        Folder f = (Folder)this.folders.get(fullId);
        if (!ValueUtil.isEmpty((Object)folder.getCaption()) && !folder.getId().equals(folder.getCaption()) && ValueUtil.isEmpty((Object)f.getCaption())) {
            f.setCaption(folder.getCaption());
        }
        return f;
    }

    public AppContext getAppContext() {
        return this.appContext;
    }
}

