/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.client.notification;

import com.rameses.client.notification.ActionLabel;
import com.rameses.client.notification.NotificationButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;

public class NotificationPopup
extends JPopupMenu {
    private NotificationButton invoker;
    private JScrollPane scrollpane;
    private JList jlist;
    private JLabel jheader;
    private Color borderColor;
    private Color backgroundColor;
    private int hoverIndex = -1;
    private ActionLabel actionLabel;
    private EventHandler eventHandler;

    public NotificationPopup(NotificationButton invoker) {
        this.invoker = invoker;
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new DefaultLayout());
        this.setBorder(new BorderImpl());
        this.setOpaque(false);
        this.borderColor = Color.decode("#a0a0a0");
        this.backgroundColor = Color.WHITE;
        this.scrollpane = new JScrollPane();
        this.scrollpane.setHorizontalScrollBarPolicy(31);
        this.scrollpane.setVerticalScrollBarPolicy(20);
        this.scrollpane.setBackground(Color.WHITE);
        this.scrollpane.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.scrollpane);
        this.jlist = new JList();
        this.jlist.setCellRenderer(new DefaultCellRenderer());
        this.jlist.setSelectionBackground(new Color(244, 246, 249));
        this.jlist.setSelectionForeground(Color.BLACK);
        this.jlist.setFixedCellHeight(40);
        this.jlist.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
                NotificationPopup.this.hoverIndex = NotificationPopup.this.jlist.locationToIndex(e.getPoint());
                NotificationPopup.this.jlist.repaint();
            }
        });
        this.jlist.addMouseListener(new MouseListener(){

            public void mouseEntered(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
                NotificationPopup.this.hoverIndex = -1;
                NotificationPopup.this.jlist.repaint();
            }

            public void mouseClicked(MouseEvent e) {
                NotificationPopup.this.onmouseClicked(e);
            }
        });
        this.scrollpane.setViewportView(this.jlist);
        this.jheader = new JLabel("Notifications");
        Font font = this.jheader.getFont();
        this.jheader.setFont(font.deriveFont(1));
        this.jheader.setForeground(Color.decode("#606060"));
        this.jheader.setBorder(new HeaderBorderImpl());
        this.add(this.jheader);
        this.actionLabel = new ActionLabel(){

            protected void onDoubleClick() {
            }

            protected void onClick() {
                if (NotificationPopup.this.eventHandler != null) {
                    NotificationPopup.this.eventHandler.seeAll();
                }
            }
        };
        this.actionLabel.setText("See All");
        this.add(this.actionLabel);
    }

    public void setData(Collection list) {
        DefaultListModel model = new DefaultListModel();
        if (list != null) {
            for (Object o : list) {
                model.addElement(o);
            }
        }
        if (model.getSize() == 0) {
            model.addElement(new NoData());
        }
        this.jlist.setModel(model);
    }

    private void onmouseClicked(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (this.eventHandler == null) {
            return;
        }
        Object value = this.jlist.getSelectedValue();
        if (value == null || value instanceof NoData) {
            return;
        }
        this.eventHandler.openItem(value);
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    private String getBeanValueAsString(Object bean, String name) {
        Object value = this.getBeanValue(bean, name);
        return value == null ? null : value.toString();
    }

    private Object getBeanValue(Object bean, String name) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(name);
        }
        Class<?> beanClass = bean.getClass();
        Method method = this.findGetMethod(beanClass, "notificationid");
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(bean, new Object[0]);
        }
        catch (Throwable t) {
            System.out.println("failed to get value from method [" + method + "] caused by " + t.getMessage());
            return null;
        }
    }

    private Method findGetMethod(Class clazz, String name) {
        try {
            if (name == null || name.length() <= 3) {
                return null;
            }
            String methodName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            for (Method method : clazz.getMethods()) {
                Class<?>[] paramTypes;
                if (!method.getName().equals(methodName) || "void".equals(method.getReturnType().toString()) || (paramTypes = method.getParameterTypes()) != null && paramTypes.length > 1) continue;
                return method;
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private class CellBorderImpl
    extends AbstractBorder {
        NotificationPopup root;
        Color borderColor;
        private boolean borderVisible;

        private CellBorderImpl() {
            this.root = NotificationPopup.this;
            this.borderColor = Color.decode("#eaeaea");
            this.borderVisible = true;
        }

        void hideBorder() {
            this.borderVisible = false;
        }

        void showBorder() {
            this.borderVisible = true;
        }

        public Insets getBorderInsets(Component c) {
            Insets ins = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(c, ins);
        }

        public Insets getBorderInsets(Component c, Insets ins) {
            ins.right = 5;
            ins.bottom = 5;
            ins.left = 5;
            ins.top = 5;
            ins.right = 10;
            ins.left = 10;
            return ins;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (!this.borderVisible) {
                return;
            }
            Color oldColor = g.getColor();
            g.setColor(this.borderColor);
            g.drawLine(0, h - 1, w, h - 1);
            g.setColor(oldColor);
        }
    }

    private class DefaultCellRenderer
    implements ListCellRenderer {
        NotificationPopup root;
        private JLabel cellLabel;

        DefaultCellRenderer() {
            this.root = NotificationPopup.this;
            this.cellLabel = new JLabel();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CellBorderImpl border = new CellBorderImpl();
            if (index + 1 >= list.getModel().getSize()) {
                border.hideBorder();
            } else {
                border.showBorder();
            }
            this.cellLabel.setBorder(border);
            this.cellLabel.setComponentOrientation(list.getComponentOrientation());
            this.cellLabel.setSize(list.getFixedCellWidth(), list.getFixedCellHeight());
            this.cellLabel.setEnabled(list.isEnabled());
            this.cellLabel.setFont(list.getFont());
            if (isSelected || index == this.root.hoverIndex) {
                this.cellLabel.setBackground(list.getSelectionBackground());
                this.cellLabel.setForeground(list.getSelectionForeground());
                this.cellLabel.setOpaque(true);
            } else {
                this.cellLabel.setBackground(list.getBackground());
                this.cellLabel.setForeground(list.getForeground());
                this.cellLabel.setOpaque(false);
            }
            String message = null;
            message = value instanceof NoData ? "<p align=\"center\" width=\"300\">--<i> No available record(s) found </i>--</p>" : NotificationPopup.this.getBeanValueAsString(value, "message");
            this.cellLabel.setText("<html>" + (message == null ? "" : message.toString()) + "</html>");
            return this.cellLabel;
        }
    }

    private class HeaderBorderImpl
    extends AbstractBorder {
        NotificationPopup root;
        Color borderColor;

        private HeaderBorderImpl() {
            this.root = NotificationPopup.this;
            this.borderColor = Color.decode("#e7e7e7");
        }

        public Insets getBorderInsets(Component c) {
            Insets ins = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(c, ins);
        }

        public Insets getBorderInsets(Component c, Insets ins) {
            ins.right = 5;
            ins.bottom = 5;
            ins.left = 5;
            ins.top = 5;
            ins.left = 10;
            return ins;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color oldColor = g.getColor();
            g.setColor(this.borderColor);
            g.drawLine(0, h - 1, w, h - 1);
            g.setColor(oldColor);
        }
    }

    private class BorderImpl
    extends AbstractBorder {
        NotificationPopup root;

        private BorderImpl() {
            this.root = NotificationPopup.this;
        }

        public Insets getBorderInsets(Component c) {
            Insets ins = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(c, ins);
        }

        public Insets getBorderInsets(Component c, Insets ins) {
            ins.right = 2;
            ins.bottom = 2;
            ins.left = 2;
            ins.top = 2;
            return ins;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(false);
            }
            Color oldColor = g.getColor();
            g.setColor(this.root.backgroundColor);
            g.fillRoundRect(x + 2, y + 2, w - 3, h - 3, 5, 5);
            g.setColor(this.root.borderColor);
            g.drawRoundRect(x, y, w - 1, h - 1, 5, 5);
            g.setColor(oldColor);
        }
    }

    private class DefaultLayout
    implements LayoutManager {
        NotificationPopup root;

        private DefaultLayout() {
            this.root = NotificationPopup.this;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim;
                int w = 0;
                int h = 0;
                if (this.root.jheader != null) {
                    dim = this.root.jheader.getPreferredSize();
                    w = dim.width;
                    h = dim.height;
                }
                if (this.root.actionLabel != null) {
                    dim = this.root.actionLabel.getPreferredSize();
                    w += dim.width;
                    h = Math.max(dim.height, h);
                }
                if (this.root.jlist != null) {
                    dim = this.root.jlist.getPreferredSize();
                    w = Math.max(dim.width, w);
                    h += dim.height;
                }
                if (w <= 300) {
                    w = 300;
                } else if (w > 300) {
                    w = 400;
                }
                if (h <= 40) {
                    h = 40;
                } else if (h > 300) {
                    h = 300;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                if (this.root.jheader != null) {
                    Dimension dim = this.root.jheader.getPreferredSize();
                    this.root.jheader.setBounds(x, y, w, dim.height);
                    y += dim.height;
                    h -= dim.height;
                    Dimension dim2 = this.root.actionLabel.getPreferredSize();
                    int x2 = w - dim2.width - 10 + margin.left;
                    int y2 = (dim.height - dim2.height) / 2;
                    this.root.actionLabel.setBounds(x2, y2, dim2.width, dim2.height);
                }
                if (this.root.scrollpane != null) {
                    this.root.scrollpane.setBounds(x, y, w, h);
                }
            }
        }
    }

    public static interface EventHandler {
        public void openItem(Object var1);

        public void seeAll();
    }

    private class NoData {
        private NoData() {
        }
    }
}

