/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.client.notification;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class ActionLabel
extends JLabel {
    private static final int MOUSE_OUT = 1;
    private static final int MOUSE_OVER = 2;
    private int mouse_status = 1;
    private Color MAIN_COLOR = Color.BLUE;

    public ActionLabel() {
        super("ActionLabel");
        this.setForeground(this.MAIN_COLOR.darker());
        this.setCursor(new Cursor(12));
        MouseListenerImpl mouseL = new MouseListenerImpl();
        this.addMouseListener(mouseL);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mouse_status == 2) {
            Insets insets = this.getInsets();
            int left = insets.left;
            if (this.getIcon() != null) {
                left += this.getIcon().getIconWidth() + this.getIconTextGap();
            }
            int x1 = left;
            int y1 = this.getHeight() - 1;
            int x2 = (int)this.getPreferredSize().getWidth() - insets.right;
            int y2 = this.getHeight() - 1 - insets.bottom;
            g.drawLine(x1, y1, x2, y2);
        }
    }

    protected void onClick() {
    }

    protected void onDoubleClick() {
    }

    private Color brighter(Color color, float factor) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int i = (int)(1.0 / (1.0 - (double)factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / factor), 255), Math.min((int)((float)g / factor), 255), Math.min((int)((float)b / factor), 255));
    }

    private class MouseListenerImpl
    implements MouseListener {
        ActionLabel root;

        private MouseListenerImpl() {
            this.root = ActionLabel.this;
        }

        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (e.getClickCount() == 2) {
                this.root.onDoubleClick();
            } else {
                this.root.onClick();
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.root.setForeground(this.root.brighter(this.root.MAIN_COLOR, 0.8f));
            this.root.mouse_status = 2;
            this.root.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.root.setForeground(this.root.MAIN_COLOR.darker());
            this.root.mouse_status = 1;
            this.root.repaint();
        }
    }
}

