/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.sigid.device;

import com.florentis.signature.DynamicCapture;
import com.florentis.signature.SigCtl;
import com.florentis.signature.SigObj;
import com.rameses.rcp.common.SigIdModel;
import com.rameses.rcp.common.SigIdResult;
import com.rameses.rcp.sigid.SigIdDevice;

class STU430Device
implements SigIdDevice {
    private SigIdModel model;
    private int width;
    private int height;

    public STU430Device(SigIdModel model) {
        this.model = model;
        this.width = model.getWidth();
        this.height = model.getHeight();
    }

    @Override
    public void open() {
        DynamicCapture dc = new DynamicCapture();
        SigCtl sigCtl = new SigCtl();
        int rescap = dc.capture(sigCtl, " ", " ", null, null);
        if (rescap == 0) {
            SigObj sig = sigCtl.signature();
            int flags = SigObj.outputBinary | SigObj.color32BPP | SigObj.encodeData;
            int pwidth = this.width > 0 ? this.width : 300;
            int pheight = this.height > 0 ? this.height : 150;
            Object binres = sig.renderBitmap(null, pwidth, pheight, "image/png", 1.0f, 0xFF0000, 0xFFFFFF, 0.0f, 0.0f, flags);
            SigIdResultImpl result = new SigIdResultImpl();
            SigIdResultImpl.access$102(result, (byte[])binres);
            result.sigString = sig.sigText();
            result.numOfStrokes = 1;
            this.doSelect(result);
        } else {
            switch (rescap) {
                case 1: {
                    this.doClose();
                    break;
                }
                case 100: {
                    throw new RuntimeException("Signature tablet not found");
                }
                case 103: {
                    throw new RuntimeException("Capture not licensed");
                }
            }
        }
    }

    private void doSelect(Object result) {
        if (this.model != null) {
            this.model.onselect(result);
        }
    }

    private void doClose() {
        if (this.model != null) {
            this.model.onclose();
        }
    }

    private class SigIdResultImpl
    implements SigIdResult {
        private byte[] imageData;
        private String sigString;
        private String keyString;
        private int keyReceipt;
        private int numOfStrokes;

        private SigIdResultImpl() {
        }

        @Override
        public String getSigString() {
            return this.sigString;
        }

        @Override
        public String getKeyString() {
            return this.keyString;
        }

        @Override
        public int getKeyReceipt() {
            return this.keyReceipt;
        }

        @Override
        public int getNumberOfStrokes() {
            return this.numOfStrokes;
        }

        @Override
        public byte[] getImageData() {
            return this.imageData;
        }

        @Override
        public void dump() {
            System.out.println("keyReceipt=" + this.keyReceipt);
            System.out.println("numOfStrokes=" + this.numOfStrokes);
            System.out.println("keyString=" + this.keyString);
            System.out.println("sigString=" + this.sigString);
            System.out.println("imageData=" + this.getImageData());
        }

        static /* synthetic */ byte[] access$102(SigIdResultImpl x0, byte[] x1) {
            x0.imageData = x1;
            return x1;
        }
    }
}

