/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.sigid;

import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.SigIdModel;
import com.rameses.rcp.sigid.SigIdDevice;
import com.rameses.rcp.sigid.SigIdDeviceManager;
import com.rameses.rcp.sigid.SigIdDeviceProvider;
import java.util.Map;

public class SigIdViewer {
    private Map options;
    private SigIdModel model;
    private int width;
    private int height;
    private boolean autoOpenMode;

    public static void open(Map options) {
        new SigIdViewer(options).open();
    }

    public static void open(SigIdModel model) {
        new SigIdViewer(model).open();
    }

    public SigIdViewer() {
        this(new SigIdModel());
    }

    public SigIdViewer(SigIdModel model) {
        this.model = model == null ? new SigIdModel() : model;
    }

    public SigIdViewer(Map options) {
        this.model = new SigIdModelProxy(options);
    }

    public byte[] open() {
        SigIdDeviceProvider prov = SigIdDeviceManager.getProvider();
        if (prov == null) {
            throw new RuntimeException("No available signature plugin device");
        }
        SigIdDevice device = prov.create(this.model);
        device.open();
        return null;
    }

    private class SigIdModelProxy
    extends SigIdModel {
        private Map options;
        private String title;
        private Integer width;
        private Integer height;
        private Integer penWidth;
        private Integer imageXSize;
        private Integer imageYSize;
        private String key;
        private CallbackHandlerProxy onselectCallback;
        private CallbackHandlerProxy oncloseCallback;

        SigIdModelProxy(Map options) {
            this.options = options;
            this.title = this.getString(options, "title");
            this.width = this.getInt(options, "width");
            this.height = this.getInt(options, "height");
            this.penWidth = this.getInt(options, "penWidth");
            this.imageXSize = this.getInt(options, "imageXSize");
            this.imageYSize = this.getInt(options, "imageYSize");
            this.key = this.getString(options, "key");
            Object source = this.get(options, "onselect");
            if (source != null) {
                this.onselectCallback = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onclose")) != null) {
                this.oncloseCallback = new CallbackHandlerProxy(source);
            }
        }

        @Override
        public String getTitle() {
            if (this.title == null) {
                return super.getTitle();
            }
            return this.title;
        }

        @Override
        public int getWidth() {
            if (this.width == null) {
                return super.getWidth();
            }
            return this.width;
        }

        @Override
        public int getHeight() {
            if (this.height == null) {
                return super.getHeight();
            }
            return this.height;
        }

        @Override
        public int getPenWidth() {
            if (this.penWidth == null) {
                return super.getPenWidth();
            }
            return this.penWidth;
        }

        @Override
        public int getImageXSize() {
            if (this.imageXSize == null) {
                return super.getImageXSize();
            }
            return this.imageXSize;
        }

        @Override
        public int getImageYSize() {
            if (this.imageYSize == null) {
                return super.getImageYSize();
            }
            return this.imageYSize;
        }

        @Override
        public String getKey() {
            return this.key == null ? super.getKey() : this.key;
        }

        @Override
        public void onselect(Object result) {
            if (this.onselectCallback == null) {
                return;
            }
            this.onselectCallback.call(result);
        }

        @Override
        public void onclose() {
            if (this.oncloseCallback == null) {
                return;
            }
            this.oncloseCallback.call();
        }

        private Integer getInt(Map map, String name) {
            try {
                return (Integer)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private String getString(Map map, String name) {
            try {
                Object o = map.get(name);
                return o == null ? null : o.toString();
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Object get(Map map, String name) {
            return map == null ? null : map.get(name);
        }
    }
}

