/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.fingerprint;

import com.digitalpersona.uareu.Engine;
import com.digitalpersona.uareu.Fid;
import com.digitalpersona.uareu.Fmd;
import com.digitalpersona.uareu.UareUException;
import com.digitalpersona.uareu.UareUGlobal;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.imageio.ImageIO;

class ImageContext {
    private Fid fid;
    private BufferedImage image;
    private byte[] data;
    private int width;
    private int height;
    private int fingerType;
    private byte[] byteArray;
    private Fmd fmd;

    ImageContext(Fid fid) {
        this.fid = fid;
        Fid.Fiv view = fid.getViews()[0];
        this.width = view.getWidth();
        this.height = view.getHeight();
        this.data = view.getImageData();
        this.image = new BufferedImage(this.width, this.height, 10);
        this.image.getRaster().setDataElements(0, 0, this.width, this.height, this.data);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public byte[] getImageData() {
        return this.data;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFingerType() {
        return this.fingerType;
    }

    void setFingerType(int fingerType) {
        this.fingerType = fingerType;
    }

    public byte[] toByteArray() {
        try {
            if (this.image == null) {
                return null;
            }
            if (this.byteArray == null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.image, "JPG", baos);
                this.byteArray = baos.toByteArray();
            }
            return this.byteArray;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void exportToFile(File file) {
        this.exportToFile(file, "JPG");
    }

    public void exportToFile(File file, String fileFormat) {
        try {
            ImageIO.write((RenderedImage)this.image, fileFormat, file);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public byte[] getFmdData() {
        if (this.fmd == null) {
            try {
                Engine engine = UareUGlobal.GetEngine();
                this.fmd = engine.CreateFmd(this.fid, Fmd.Format.ANSI_378_2004);
            }
            catch (UareUException ue) {
                String str = String.format("%s returned error %d \n%s", "CreateFmd", ue.getCode() & 0xFFFF, ue.toString());
                throw new RuntimeException(str);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return this.fmd.getData();
    }

    private String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        int v = 0;
        for (int j = 0; j < bytes.length; ++j) {
            v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

