/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.fingerprint;

import com.rameses.rcp.fingerprint.FingerPrintDataModel;
import com.rameses.rcp.fingerprint.ImageContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

class FingerPrintImage
extends JPanel
implements FingerPrintDataModel.Item {
    private static final long serialVersionUID = 1L;
    private ImageContext imageContext;
    private ImageRenderer renderer;
    private JLabel label;
    private int fingerType;
    private FingerPrintDataModel model;
    private boolean selected;

    public FingerPrintImage(String caption, int fingerType) {
        this.fingerType = fingerType;
        this.initComponent();
        this.setCaption(caption);
    }

    private void initComponent() {
        super.setLayout(new DefaultLayout());
        this.renderer = new ImageRenderer();
        this.add(this.renderer);
        this.label = new JLabel("");
        this.label.setHorizontalAlignment(0);
        this.label.setBorder(BorderFactory.createEmptyBorder(3, 2, 3, 2));
        this.add(this.label);
    }

    public void setCaption(String caption) {
        this.label.setText(caption == null ? "" : caption);
    }

    @Override
    public void setModel(FingerPrintDataModel model) {
        this.model = model;
    }

    public ImageContext getImageContext() {
        return this.imageContext;
    }

    @Override
    public void setImageContext(ImageContext imageContext) {
        this.imageContext = imageContext;
        if (imageContext != null) {
            imageContext.setFingerType(this.fingerType);
        }
        this.renderer.repaint();
    }

    @Override
    public void refresh() {
        this.selected = this.model.isSelected(this);
        this.renderer.repaint();
    }

    private class ImageRenderer
    extends JLabel {
        FingerPrintImage root;
        private Color shadow;
        private Color darkShadow;

        ImageRenderer() {
            this.root = FingerPrintImage.this;
            this.setPreferredSize(new Dimension(178, 196));
            this.setHorizontalAlignment(0);
            this.shadow = this.getBackground().darker();
            this.darkShadow = this.shadow.darker();
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    ImageRenderer.this.onmousePressed(e);
                }
            });
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    ImageRenderer.this.onkeyTyped(e);
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int width = this.getWidth();
            int height = this.getHeight();
            Color oldColor = g.getColor();
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.WHITE);
            Rectangle clip = g2.getClipBounds();
            g2.clearRect(0, 0, clip.width, clip.height);
            if (FingerPrintImage.this.imageContext != null) {
                int px = Math.max((width - FingerPrintImage.this.imageContext.getWidth()) / 2, 0);
                int py = Math.max((height - FingerPrintImage.this.imageContext.getHeight()) / 2, 0);
                int pw = Math.min(width, FingerPrintImage.this.imageContext.getWidth());
                int ph = Math.min(height, FingerPrintImage.this.imageContext.getHeight());
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.drawImage(FingerPrintImage.this.imageContext.getImage(), px, py, pw, ph, null);
            }
            g2.setColor(this.shadow);
            g2.drawRect(0, 0, width - 1, height - 1);
            if (FingerPrintImage.this.selected) {
                g2.setColor(new Color(51, 153, 255));
                g2.drawRect(0, 0, width - 1, height - 1);
                g2.setColor(this.shadow);
                g2.drawRect(1, 1, width - 3, height - 3);
            }
            g2.setColor(oldColor);
        }

        private void onmousePressed(MouseEvent e) {
            this.root.model.setSelectedItem(this.root);
            this.root.model.refresh();
        }

        private void onkeyTyped(KeyEvent e) {
            if (e.getKeyCode() == 39) {
                int index = this.root.model.indexOf(this.root);
                FingerPrintDataModel.Item item = this.root.model.getItem(index + 1);
                if (item == null) {
                    return;
                }
                this.root.model.setSelectedItem(item);
                this.root.model.refresh();
            } else if (e.getKeyCode() == 37) {
                int index = this.root.model.indexOf(this.root);
                FingerPrintDataModel.Item item = this.root.model.getItem(index - 1);
                if (item == null) {
                    return;
                }
                this.root.model.setSelectedItem(item);
                this.root.model.refresh();
            }
        }
    }

    private class DefaultLayout
    implements LayoutManager {
        private DefaultLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    w = Math.max(dim.width, w);
                    h += dim.height;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(x, y, w, dim.height);
                    y += dim.height;
                }
            }
        }
    }
}

