/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.fingerprint;

import com.digitalpersona.uareu.Fid;
import com.digitalpersona.uareu.Reader;
import com.digitalpersona.uareu.UareUException;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.fingerprint.CaptureThread;
import com.rameses.rcp.fingerprint.ImageContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

class CapturePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Reader reader;
    private boolean streaming;
    private CaptureThread capture_thread;
    private ImageContext imageContext;

    public CapturePanel() {
        this.setPreferredSize(new Dimension(360, 390));
        this.setBackground(Color.WHITE);
    }

    void start(Reader reader, boolean streaming) {
        if (this.capture_thread != null) {
            return;
        }
        this.reader = reader;
        this.streaming = streaming;
        this.startCaptureThread();
    }

    void stop() {
        if (this.capture_thread != null) {
            this.capture_thread.cancel();
        }
    }

    void waitForCaptureThread() {
        if (this.capture_thread != null) {
            this.capture_thread.join(1000);
        }
    }

    byte[] getImageData() {
        try {
            BufferedImage bi;
            BufferedImage bufferedImage = bi = this.imageContext == null ? null : this.imageContext.getImage();
            if (bi == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "JPG", baos);
            return baos.toByteArray();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.imageContext == null) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(this.getBackground());
        Rectangle clip = g2.getClipBounds();
        g2.clearRect(0, 0, clip.width, clip.height);
        int x = Math.max((width - this.imageContext.getWidth()) / 2, 0);
        int y = Math.max((height - this.imageContext.getHeight()) / 2, 0);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage((Image)this.imageContext.getImage(), x, y, null);
    }

    private void startCaptureThread() {
        this.capture_thread = new CaptureThread(this.reader, this.streaming, Fid.Format.ANSI_381_2004, Reader.ImageProcessing.IMG_PROC_DEFAULT);
        this.capture_thread.start(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CapturePanel.this.actionPerformedImpl(e);
            }
        });
    }

    private void actionPerformedImpl(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (!"finger_print_capture_thread".equals(cmd)) {
            return;
        }
        ImageContext newImageContext = null;
        boolean cancelled = false;
        CaptureThread.CaptureEvent evt = (CaptureThread.CaptureEvent)e;
        if (evt.getException() != null) {
            UareUException ue = evt.getException();
            String str = String.format("%s returned error %d \n%s", "Capture", ue.getCode() & 0xFFFF, ue.toString());
            MsgBox.err((Object)str);
        } else if (evt.getResult() != null) {
            Reader.CaptureResult result = evt.getResult();
            if (result.image != null && result.quality == Reader.CaptureQuality.GOOD) {
                newImageContext = new ImageContext(result.image);
            } else if (result.quality == Reader.CaptureQuality.CANCELED) {
                cancelled = true;
            } else {
                MsgBox.err((Object)result.quality);
            }
        } else if (evt.getStatus() != null) {
            String str = String.format("Reader status: %s", evt.getStatus().toString());
            MsgBox.err((Object)str);
        }
        this.imageContext = newImageContext;
        this.fireImageDataChanged(this.imageContext);
        this.repaint();
        if (!cancelled && !this.streaming) {
            this.waitForCaptureThread();
            this.startCaptureThread();
        }
    }

    private void fireImageDataChanged(final ImageContext ctx) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                byte[] data = ctx == null ? null : ctx.getImageData();
                CapturePanel.this.firePropertyChange("imageDataChanged", "", data);
            }
        });
    }
}

