/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.common;

import com.rameses.common.MethodResolver;
import com.rameses.osiris2.client.InvokerProxy;
import com.rameses.osiris2.client.WorkUnitUIController;
import com.rameses.rcp.annotations.Controller;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.Modal;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.PopupMenuOpener;
import com.rameses.rcp.framework.Binding;
import com.rameses.util.BreakException;
import com.rameses.util.Warning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class WorkflowController {
    @com.rameses.rcp.annotations.Binding
    private Binding binding;
    @Controller
    private WorkUnitUIController controller;
    private Map entity = new HashMap();
    private List formActions = new ArrayList();
    private List extActions = new ArrayList();
    private String title;
    private String message;
    private WorkflowServiceProxy _wfService;
    private Map task;
    private List tasks = new ArrayList();
    private List messagelist = new ArrayList();
    private List<WorkflowAction> workActions = new ArrayList<WorkflowAction>();

    public void beforeOpen(Object o) {
    }

    public void afterOpen(Object o) {
    }

    public void beforeSignal(Object task) {
    }

    public void afterSignal(Object result) {
    }

    public Object handleWarning(Warning w) {
        throw w;
    }

    public Object getService() {
        return null;
    }

    public Object findPage(Map task) {
        return null;
    }

    public String getServiceName() {
        throw new RuntimeException("Service name not specified");
    }

    public void buildExtActions() {
        List list;
        this.extActions.clear();
        if (this.task != null && this.task.get("workitemtypes") != null && (list = (List)this.task.get("workitemtypes")) != null && list.size() > 0) {
            this.extActions.add(new Action("addWorkitem", "Add Work Item", null));
        }
    }

    private void buildFormActions(Map task) {
        boolean pass = false;
        try {
            pass = Boolean.parseBoolean(task.get("owner") + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!pass) {
            return;
        }
        List transitions = (List)task.get("transitions");
        if (transitions == null) {
            return;
        }
        this.workActions.clear();
        for (Map t : transitions) {
            HashMap props = (HashMap)t.get("properties");
            if (props == null) {
                props = new HashMap();
                t.put("properties", props);
            }
            boolean visible = true;
            if (props.get("visible") != null) {
                try {
                    visible = Boolean.parseBoolean(props.get("visible").toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String name = (String)t.get("action");
            WorkflowAction wa = new WorkflowAction(name, task, t);
            if (visible) {
                this.formActions.add(wa);
            }
            this.workActions.add(wa);
        }
        this.buildExtActions();
        this.message = null;
        if (task.get("message") != null) {
            this.message = (String)task.get("message");
            this.messagelist.clear();
            this.messagelist.add(this.message);
        }
    }

    public List getMessagelist() {
        return this.messagelist;
    }

    public Object addWorkitem() {
        PopupMenuOpener opener = new PopupMenuOpener();
        for (Object m : (List)this.task.get("workitemtypes")) {
            Map o = (Map)m;
            WorkitemAction a = new WorkitemAction(o);
            a.setCaption(o.get("title") + "");
            opener.add((Object)a);
        }
        return opener;
    }

    private WorkflowServiceProxy getWfService() {
        if (this._wfService != null) {
            return this._wfService;
        }
        Object ws = this.getService();
        this._wfService = ws != null ? new WorkflowServiceProxy(ws) : new WorkflowServiceProxy(InvokerProxy.getInstance().create(this.getServiceName()));
        return this._wfService;
    }

    public Object open() throws Exception {
        this.beforeOpen(this.entity);
        if (this.entity.get("taskid") == null) {
            throw new Exception("Please indicate a taskid in the selectedItem");
        }
        HashMap map = new HashMap();
        map.put("taskid", this.entity.get("taskid"));
        this.task = this.getWfService().openTask(map);
        this.formActions.clear();
        this.formActions.add(new Action("_close", "Close", null));
        this.buildFormActions(this.task);
        if (this.task.get("data") instanceof Map) {
            this.entity = (Map)this.task.remove("data");
            this.entity.put("currenttask", this.task);
        } else {
            MsgBox.warn((Object)"Warning. Please add a data in task info. Entity will be empty");
        }
        this.afterOpen(this.entity);
        Object nextPage = this.findPage(this.task);
        if (nextPage == null) {
            return "default";
        }
        return nextPage;
    }

    public Object signal() throws Exception {
        if (this.workActions.size() > 0) {
            WorkflowAction wfa = this.workActions.iterator().next();
            return wfa.execute();
        }
        throw new Exception("No action to signal found");
    }

    public void onEnd() {
    }

    public Object signal(String action) throws Exception {
        if (action == null) {
            throw new Exception("Please provide an action in signal");
        }
        WorkflowAction wfa = null;
        for (WorkflowAction wa : this.workActions) {
            if (!action.equals(wa.getName())) continue;
            wfa = wa;
            break;
        }
        if (wfa == null) {
            throw new Exception("Action " + action + " not found");
        }
        return wfa.execute();
    }

    private Object invokeSignal(Map req) throws Exception {
        this.formActions.clear();
        this.formActions.add(new Action("_close", "Close", null));
        Map result = this.getWfService().signal(req);
        if (result.get("task") == null) {
            return null;
        }
        this.task = (Map)result.get("task");
        this.tasks = (List)result.get("tasks");
        this.buildFormActions(this.task);
        return result;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public Map getEntity() {
        return this.entity;
    }

    public void setEntity(Map entity) {
        this.entity = entity;
    }

    public List getFormActions() {
        return this.formActions;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map getTask() {
        return this.task;
    }

    public List getExtActions() {
        return this.extActions;
    }

    public class WorkflowAction
    extends Action {
        private Map task;
        private String confirm;
        private String messageHandler;
        private List assignees;
        private boolean closeOnEnd;
        private String tag;
        private String visibleWhen;
        private String to;
        private String parentid;

        public WorkflowAction(String n, Map task, Map t) {
            super(n);
            this.task = task;
            if (task.get("domain") != null) {
                this.setDomain(task.get("domain").toString());
            }
            if (task.get("role") != null) {
                this.setRole(task.get("role").toString());
            }
            if (t.get("permission") != null) {
                this.setPermission(t.get("permission").toString());
            }
            if (t.get("assignees") != null) {
                this.assignees = (List)t.get("assignees");
            }
            String caption = this.getName();
            this.messageHandler = null;
            Map props = (Map)t.get("properties");
            if (props != null) {
                Object val;
                if (props.get("caption") != null) {
                    caption = props.get("caption").toString();
                }
                if (props.get("confirm") != null) {
                    this.confirm = props.get("confirm").toString();
                }
                if (props.get("messagehandler") != null) {
                    this.messageHandler = props.get("messagehandler").toString();
                    if (this.messageHandler.equalsIgnoreCase("default")) {
                        this.messageHandler = "taskmessage:create";
                    }
                }
                if (props.get("closeonend") != null) {
                    try {
                        this.closeOnEnd = Boolean.parseBoolean(props.get("closeonend") + "");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.tag = (val = props.get("tag")) == null ? null : val.toString();
                val = props.get("visibleWhen");
                String string = this.visibleWhen = val == null ? null : val.toString();
            }
            if (caption == null) {
                caption = "Submit";
            }
            this.setCaption(caption);
            this.to = this.getString(t, "to");
            this.parentid = this.getString(t, "parentid");
            if (this.parentid == null) {
                this.parentid = this.getString(t, "currentname");
            }
        }

        public String getVisibleWhen() {
            if (this.visibleWhen != null && this.visibleWhen.trim().length() > 0) {
                return this.visibleWhen;
            }
            return super.getVisibleWhen();
        }

        public Object execute() {
            try {
                Object result;
                boolean pass;
                if (this.task.get("state") == null) {
                    throw new Exception("WorkflowController.execute error. There is no state in task.");
                }
                String action = this.getName();
                HashMap req = new HashMap();
                req.put("taskid", this.task.get("objid"));
                req.put("refid", this.task.get("refid"));
                req.put("data", WorkflowController.this.entity);
                req.put("state", this.task.get("state"));
                req.put("extended", this.task.get("extended"));
                if (action != null && action.trim().length() > 0) {
                    req.put("action", action);
                }
                if (this.tag != null) {
                    req.put("tag", this.tag);
                }
                req.put("to", this.to == null ? null : this.to);
                WorkflowController.this.beforeSignal(req);
                if (this.confirm != null && !(pass = MsgBox.confirm((Object)this.confirm))) {
                    return null;
                }
                if (this.messageHandler != null) {
                    final HashMap resmap = new HashMap();
                    Callable c = new Callable(){

                        public Object call() throws Exception {
                            resmap.put("pass", true);
                            return null;
                        }
                    };
                    try {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("task", req);
                        params.put("assignees", this.assignees);
                        params.put("handler", c);
                        HashMap<String, String> opt = new HashMap<String, String>();
                        opt.put("title", this.getCaption());
                        Modal.show((String)this.messageHandler, params, opt);
                        if (!resmap.containsKey("pass")) {
                            throw new BreakException();
                        }
                    }
                    catch (BreakException be) {
                        throw be;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new Exception("Error on displaying " + this.messageHandler, e);
                    }
                }
                if ((result = WorkflowController.this.invokeSignal(req)) == null) {
                    WorkflowController.this.onEnd();
                    if (this.closeOnEnd) {
                        return "_close";
                    }
                    return null;
                }
                WorkflowController.this.afterSignal(result);
                WorkflowController.this.binding.refresh();
                return WorkflowController.this.findPage(this.task);
            }
            catch (Warning w) {
                return WorkflowController.this.handleWarning(w);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        String getString(Map data, Object key) {
            Object obj = data == null ? null : (Object)data.get(key);
            return obj == null ? null : obj.toString();
        }
    }

    public class WorkflowServiceProxy {
        private Object proxy;
        private MethodResolver resolver = MethodResolver.getInstance();

        public WorkflowServiceProxy(Object proxy) {
            this.proxy = proxy;
        }

        public Map openTask(Map p) throws Exception {
            return (Map)this.resolver.invoke(this.proxy, "openTask", new Object[]{p});
        }

        public Map signal(Map p) throws Exception {
            return (Map)this.resolver.invoke(this.proxy, "signal", new Object[]{p});
        }

        public List getSubTaskTypes(Map p) throws Exception {
            return (List)this.resolver.invoke(this.proxy, "getSubTaskTypes", new Object[]{p});
        }

        public void addWorkItem(Map p) throws Exception {
            this.resolver.invoke(this.proxy, "addWorkitem", new Object[]{p});
        }
    }

    private class WorkitemAction
    extends Action {
        private Map workitem;

        public WorkitemAction(Map m) {
            this.workitem = m;
        }

        public Object execute() {
            HashMap req = new HashMap();
            req.put("name", this.workitem.get("name"));
            req.put("taskid", WorkflowController.this.task.get("objid"));
            req.put("action", this.workitem.get("action"));
            req.put("refid", WorkflowController.this.task.get("refid"));
            req.put("workitemid", this.workitem.get("objid"));
            HashMap params = new HashMap();
            params.put("task", req);
            params.put("assignees", this.workitem.get("assignees"));
            HashMap<String, String> opt = new HashMap<String, String>();
            opt.put("title", this.getCaption());
            Modal.show((String)"taskmessage:create", params, opt);
            if (req.get("message") == null) {
                return null;
            }
            try {
                WorkflowController.this.getWfService().addWorkItem(req);
                MsgBox.alert((Object)(this.getCaption() + " workitem created"));
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

