/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.common;

import com.rameses.io.AbstractChunkHandler;
import com.rameses.io.ChunkHandler;
import com.rameses.io.FileObject;
import com.rameses.osiris2.client.OsirisContext;
import com.rameses.osiris2.common.FileUploadHandler;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.service.ScriptServiceContext;
import com.rameses.util.Base64Cipher;
import com.rameses.util.Encoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FileService {
    private static final ExecutorService threadPool = Executors.newCachedThreadPool();
    private IService iSvc;
    private IUploadService iuSvc;

    public void upload(File file) {
        this.upload(file, null);
    }

    public void upload(File file, FileUploadHandler handler) {
        threadPool.submit(new FileUploadTask(file, handler));
    }

    public File getFile(String id) {
        ResourceObject ro = new ResourceObject(id);
        return ro.getFile();
    }

    public URL getURL(String id) {
        try {
            File file = this.getFile(id);
            if (file == null) {
                return null;
            }
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public InputStream getInputStream(String id) {
        try {
            File file = this.getFile(id);
            if (file == null) {
                return null;
            }
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void remove(String id) {
        ResourceObject ro = new ResourceObject(id);
        ro.remove(id);
    }

    private Map getAppEnv() {
        return ClientContext.getCurrentContext().getAppEnv();
    }

    private IService getService() {
        if (this.iSvc == null) {
            ScriptServiceContext context = new ScriptServiceContext(this.getAppEnv());
            this.iSvc = (IService)context.create("FileService", OsirisContext.getEnv(), IService.class);
        }
        return this.iSvc;
    }

    private IUploadService getUploadService() {
        if (this.iuSvc == null) {
            ScriptServiceContext context = new ScriptServiceContext(this.getAppEnv());
            this.iuSvc = (IUploadService)context.create("FileUploadService", OsirisContext.getEnv(), IUploadService.class);
        }
        return this.iuSvc;
    }

    public void runCleanupTask() {
        threadPool.submit(new CleanupTask());
    }

    private File getTempDir() {
        File ftempdir;
        File basedir;
        String tempdir;
        Map appenv = this.getAppEnv();
        Object objval = appenv == null ? null : (Object)appenv.get("tempdir");
        String string = tempdir = objval == null ? null : objval.toString();
        if (tempdir == null || tempdir.length() == 0) {
            tempdir = System.getProperty("java.io.tmpdir");
        }
        if (!(basedir = new File(ftempdir = new File(tempdir), "rameses")).exists()) {
            basedir.mkdir();
        }
        return basedir;
    }

    private class CleanupTask
    implements Runnable {
        private CleanupTask() {
        }

        @Override
        public void run() {
            this.removeObsoleteFiles();
        }

        void removeObsoleteFiles() {
            File[] files;
            File basedir = FileService.this.getTempDir();
            Calendar cal = Calendar.getInstance();
            for (File f : files = basedir.listFiles()) {
                cal.setTimeInMillis(f.lastModified());
                cal.add(10, 24);
                if (cal.getTimeInMillis() >= System.currentTimeMillis()) continue;
                try {
                    this.delete(f);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        void delete(File f) {
            if (f.isDirectory()) {
                File[] files;
                for (File o : files = f.listFiles()) {
                    this.delete(o);
                }
            }
            f.delete();
        }
    }

    private class ResourceObject {
        private Base64Cipher base64;
        private String encid;
        private String id;

        ResourceObject(String id) {
            this.id = id;
            this.base64 = new Base64Cipher();
            this.encid = Encoder.MD5.encode(id);
        }

        File getFile() {
            File basedir = FileService.this.getTempDir();
            File file = new File(basedir, this.encid);
            if (!file.exists()) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("objid", this.id);
                Map result = FileService.this.getService().findHeader(params);
                Number chunkcount = (Number)result.get("chunkcount");
                String context = (String)result.get("context");
                File tmpfile = new File(basedir, this.encid + "~");
                this.downloadData(tmpfile, context, chunkcount.intValue());
                tmpfile.renameTo(file);
            }
            return file;
        }

        void remove(String id) {
            if (id != null && id.trim().length() > 0) {
                File basedir = FileService.this.getTempDir();
                File file = new File(basedir, this.encid);
                if (file.exists()) {
                    file.delete();
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("fileid", this.id);
                FileService.this.getService().removeFile(params);
            }
        }

        boolean downloadData(File file, String context, int chunkcount) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                for (int startidx = 1; startidx <= chunkcount; startidx += 6) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("context", context);
                    params.put("fileid", this.id);
                    params.put("startindexno", startidx);
                    params.put("endindexno", startidx + 5);
                    List results = FileService.this.getService().getItems(params);
                    for (Object item : results) {
                        Map map = (Map)item;
                        Object content = map.remove("content");
                        if (content == null) continue;
                        Map dmap = (Map)this.base64.decode(content.toString());
                        byte[] bytes = (byte[])dmap.remove("content");
                        fos.write(bytes, 0, bytes.length);
                    }
                }
                fos.flush();
                boolean bl = true;
                return bl;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private class FileUploadTask
    extends AbstractChunkHandler
    implements Runnable {
        private File file;
        private FileUploadHandler handler;
        private Exception error;
        private List batches = new ArrayList();
        private Base64Cipher cipher = new Base64Cipher();

        FileUploadTask(File file, FileUploadHandler handler) {
            this.file = file;
            this.handler = handler == null ? new FileUploadHandler() : handler;
        }

        @Override
        public void run() {
            FileObject fo = new FileObject(this.file);
            fo.read((ChunkHandler)this);
        }

        public void start() {
            try {
                FileObject.MetaInfo meta = this.getMeta();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("objid", meta.getId());
                data.put("filename", meta.getFileName());
                data.put("filetype", meta.getFileType());
                data.put("filesize", meta.getFileSize());
                data.put("chunkcount", meta.getChunkCount());
                FileService.this.getUploadService().create(data);
                this.handler.start(data);
            }
            catch (Exception ex) {
                this.error = ex;
                this.cancel();
            }
        }

        public void end() {
            if (this.isCancelled()) {
                try {
                    FileObject.MetaInfo meta = this.getMeta();
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("fileid", meta.getId());
                    FileService.this.getUploadService().removeFile(params);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                try {
                    if (!this.batches.isEmpty()) {
                        this.uploadBatch();
                    }
                }
                catch (Exception ex) {
                    this.error = ex;
                }
            }
            if (this.error != null) {
                this.handler.error(this.error);
            }
            this.handler.end();
        }

        public void handle(int indexno, byte[] bytes) {
            try {
                FileObject.MetaInfo meta = this.getMeta();
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("parentid", meta.getId());
                item.put("indexno", indexno);
                item.put("content", bytes);
                item.put("contentsize", bytes.length);
                this.batches.add(item);
                if (this.batches.size() >= 5) {
                    this.uploadBatch();
                }
                this.handler.process(item);
            }
            catch (Exception ex) {
                this.error = ex;
                this.cancel();
            }
        }

        private void uploadBatch() {
            FileObject.MetaInfo meta = this.getMeta();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("fileid", meta.getId());
            params.put("items", this.batches);
            FileService.this.getUploadService().addItems(params);
            this.batches.clear();
        }
    }

    static interface IService {
        public Map findHeader(Map var1);

        public Map findItem(Map var1);

        public List getItems(Map var1);

        public void removeFile(Object var1);
    }

    static interface IUploadService {
        public Object create(Object var1);

        public Object addItem(Object var1);

        public void addItems(Object var1);

        public void removeFile(Object var1);
    }
}

