/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.common;

import com.rameses.common.ExpressionResolver;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.osiris2.common.ExplorerViewController;
import com.rameses.osiris2.common.ExplorerViewService;
import com.rameses.osiris2.common.ListController;
import com.rameses.osiris2.common.ListModelHandler;
import com.rameses.osiris2.common.ListService;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.IconColumnHandler;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Node;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PopupMenuOpener;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.ImageIconSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;

public class ExplorerViewListController
extends ListController {
    private Node node;
    private ExplorerViewService service;
    private List<Invoker> defaultInvokers;
    private List<Action> formActions = new ArrayList<Action>();
    private List<Action> nodeActions = new ArrayList<Action>();
    private Object extendedParams;
    private boolean _showQueryForm = false;
    private Opener customQueryForm;
    private Map extProperties = new HashMap();
    private DefaultListService defaultService = new DefaultListService();
    private ActionsProvider actionsProvider = new ActionsProvider();
    private ExplorerViewController parentController;
    private List navActions;

    public void setExtendedProperties(Map ext) {
        this.extProperties.clear();
        if (ext == null) {
            return;
        }
        for (Object key : ext.keySet()) {
            this.extProperties.put("_" + key, ext.get(key));
        }
    }

    @Override
    public String getTitle() {
        Node node = this.getNode();
        if (node == null) {
            return null;
        }
        Object val = node.getProperty("title");
        return val == null ? node.getCaption() : val.toString();
    }

    @Override
    public String getServiceName() {
        throw new IllegalStateException("Please specify a serviceName");
    }

    @Override
    public String getEntityName() {
        throw new IllegalStateException("Please specify an entityName");
    }

    @Override
    public List getFormActions() {
        return this.formActions;
    }

    public List getNodeActions() {
        return this.nodeActions;
    }

    @Override
    public int getRows() {
        return 20;
    }

    public boolean isQueryFormVisible() {
        return this._showQueryForm;
    }

    @Override
    public boolean isAllowCreate() {
        if (this.parentController == null) {
            return super.isAllowCreate();
        }
        return this.parentController.isAllowCreate();
    }

    @Override
    public boolean isAllowOpen() {
        if (this.parentController == null) {
            return super.isAllowOpen();
        }
        return this.parentController.isAllowOpen();
    }

    public void setParent(ExplorerViewController parentController) {
        this.parentController = parentController;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    @Override
    protected ListService getService() {
        if (this.parentController == null) {
            return this.defaultService;
        }
        return this.parentController.getService();
    }

    public void updateView() {
        String tag;
        String nodeName;
        Node node = this.getNode();
        String string = nodeName = node == null ? null : node.getPropertyString("name");
        if ("search".equals(nodeName + "")) {
            this._showQueryForm = true;
        } else {
            String _allowSearch = node == null ? null : node.getPropertyString("allowSearch");
            String _queryform = node == null ? null : node.getPropertyString("queryform");
            this._showQueryForm = "true".equals(_allowSearch);
            if (this._showQueryForm && _queryform != null) {
                this.customQueryForm = new Opener();
                this.customQueryForm.setOutcome(_queryform);
            } else {
                this.customQueryForm = null;
            }
        }
        this.getQuery().clear();
        this.getQuery().putAll(this.extProperties);
        this.buildActions();
        Binding binding = this.getBinding();
        if (binding != null) {
            binding.refresh("formActions");
        }
        if ((tag = super.getTag()) != null) {
            this.getQuery().put("_tag", tag);
        }
        this.reloadAll();
    }

    private Node getChildNode(String filetype) {
        Node node = this.getNode();
        if (node == null || filetype == null) {
            return null;
        }
        List cnodes = node.getItems();
        for (Node cnode : cnodes) {
            String cfiletype = cnode.getPropertyString("filetype") + "";
            if (!cfiletype.equalsIgnoreCase(filetype)) continue;
            return cnode;
        }
        return null;
    }

    private void buildActions() {
        List<Invoker> list;
        List<Action> actionlist;
        Object a;
        String invtype;
        String scaption;
        String invtype2;
        Invoker invoker;
        Map citem;
        String cfiletype;
        List<Object> list2;
        ArrayList children;
        this.formActions.clear();
        this.nodeActions.clear();
        this.formActions.add(this.createAction("listHandler.reload", "Refresh", "images/toolbars/refresh.png", "ctrl R", 'r', null, true));
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        String filetype = node.getPropertyString("filetype");
        if (filetype != null) {
            Invoker invoker2 = (Invoker)node.getProperty("Invoker.edit");
            if (invoker2 == null) {
                String invtype3 = filetype.toLowerCase() + ":open";
                invoker2 = this.actionsProvider.getInvoker(node, invtype3);
                node.setProperty("Invoker.edit", (Object)invoker2);
            }
            if (invoker2 != null) {
                Action a2 = this.createAction("listHandler.edit", "", "images/toolbars/edit.png", "ctrl E", 'e', null, true);
                this.nodeActions.add(a2);
            }
        }
        if ((children = node.getPropertyList("children")) == null) {
            children = new ArrayList();
        }
        if (this.isAllowCreate()) {
            list2 = node.getPropertyList("Invoker.createlist");
            if (list2 == null) {
                Invoker invoker3;
                String cfiletype2;
                list2 = new ArrayList<Invoker>();
                if (!children.isEmpty()) {
                    for (Object o : children) {
                        if (!(o instanceof Map) || (cfiletype = this.getString(citem = (Map)o, "filetype")) == null || cfiletype.trim().length() == 0 || (invoker = this.actionsProvider.getInvoker(node, invtype2 = cfiletype.toLowerCase() + ":create")) == null) continue;
                        invoker = invoker.clone();
                        invoker.getProperties().put("Node.fileTypeObject", citem);
                        scaption = this.getString(citem, "caption");
                        if (scaption != null) {
                            invoker.setCaption(scaption);
                        }
                        list2.add(invoker);
                    }
                }
                if (list2.isEmpty() && (cfiletype2 = this.parentController.getDefaultFileType()) != null && cfiletype2.length() > 0 && (invoker3 = this.actionsProvider.getInvoker(node, invtype = cfiletype2.toLowerCase() + ":create")) != null) {
                    invoker3 = invoker3.clone();
                    HashMap<String, String> citem2 = new HashMap<String, String>();
                    citem2.put("filetype", cfiletype2);
                    invoker3.getProperties().put("Node.fileTypeObject", citem2);
                    list2.add(invoker3);
                }
                node.setProperty("Invoker.createlist", list2);
            }
            if (!list2.isEmpty()) {
                a = this.createAction("listHandler.create", "New", "images/toolbars/create.png", "ctrl N", 'n', null, true);
                this.formActions.add((Action)a);
            }
        }
        if (this.isAllowOpen()) {
            list2 = node.getPropertyList("Invoker.openlist");
            if (list2 == null) {
                list2 = new ArrayList();
                if (!children.isEmpty()) {
                    for (Object o : children) {
                        if (!(o instanceof Map) || (cfiletype = this.getString(citem = (Map)o, "filetype")) == null || cfiletype.trim().length() == 0 || (invoker = this.actionsProvider.getInvoker(node, invtype2 = cfiletype.toLowerCase() + ":open")) == null) continue;
                        invoker = invoker.clone();
                        invoker.getProperties().put("Node.fileTypeObject", citem);
                        scaption = this.getString(citem, "caption");
                        if (scaption != null) {
                            invoker.setCaption(scaption);
                        }
                        list2.add(invoker);
                    }
                }
                node.setProperty("Invoker.openlist", list2);
            }
            a = this.createAction("listHandler.open", "Open", "images/toolbars/open.png", "ctrl O", 'o', "#{listHandler.selectedEntity != null}", true);
            a.getProperties().put("depends", "listHandler.selectedEntity");
            this.formActions.add((Action)a);
        }
        if ((actionlist = this.parentController.lookupActions("formActions")) != null) {
            this.formActions.addAll(actionlist);
        }
        if ((list = node.getPropertyList("Invoker.formActions")) == null) {
            if (filetype == null) {
                filetype = this.parentController.getDefaultFileType();
            }
            if (filetype != null) {
                invtype = filetype.toLowerCase() + ":formActions";
                list = this.actionsProvider.getInvokers(node, invtype);
                node.setProperty("Invoker.formActions", list);
            }
        }
        if (list != null && !list.isEmpty()) {
            for (Invoker invoker3 : list) {
                this.formActions.add(new ActionInvoker(invoker3));
            }
        }
    }

    private void buildActionsForSearchNode() {
        String dfiletype;
        this.formActions.clear();
        this.nodeActions.clear();
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        String string = dfiletype = this.parentController == null ? null : this.parentController.getDefaultFileType();
        if (dfiletype == null || dfiletype.length() == 0) {
            return;
        }
        this.formActions.add(this.createAction("listHandler.reload", "Refresh", "images/toolbars/refresh.png", "ctrl R", 'r', null, true));
    }

    @Override
    public List getNavActions() {
        if (this.navActions == null) {
            if (!this.isShowNavActions()) {
                return null;
            }
            this.navActions = new ArrayList();
            this.navActions.add(this.createAction("listHandler.moveFirstPage", "", "images/navbar/first.png", null, '\u0000', null, true));
            this.navActions.add(this.createAction("listHandler.moveBackPage", "", "images/navbar/previous.png", null, '\u0000', null, true));
            this.navActions.add(this.createAction("listHandler.moveNextPage", "", "images/navbar/next.png", null, '\u0000', null, true));
            this.navActions.add(this.createAction("listHandler.moveLastPage", "", "images/navbar/last.png", null, '\u0000', null, true));
        }
        return this.navActions;
    }

    @Override
    public Opener getQueryForm() {
        if (!this.isAllowSearch()) {
            return null;
        }
        if (this.customQueryForm == null) {
            return super.getQueryForm();
        }
        return this.customQueryForm;
    }

    @Override
    protected void beforeGetColumns(Map params) {
        Object item;
        params.putAll(this.extProperties);
        Node node = this.getNode();
        Object object = item = node == null ? null : node.getItem();
        if (item instanceof Map) {
            params.putAll((Map)item);
        }
    }

    @Override
    protected void onbeforeFetchList(Map params) {
        Object item;
        Node node = this.getNode();
        Object object = item = node == null ? null : node.getItem();
        if (item instanceof Map) {
            params.putAll((Map)item);
        }
        if (this.parentController != null) {
            this.parentController.beforeFetchList(params);
        }
    }

    public Column[] initColumns(Column[] columns) {
        if (columns == null || columns.length == 0) {
            return columns;
        }
        Column[] newColumns = new Column[columns.length + 1];
        for (int i = 0; i < columns.length; ++i) {
            newColumns[i + 1] = columns[i];
        }
        Column aColumn = new Column(null, "");
        aColumn.setTypeHandler((Column.TypeHandler)new DefaultIconColumnHandler());
        aColumn.setResizable(false);
        aColumn.setWidth(25);
        newColumns[0] = aColumn;
        return newColumns;
    }

    @Override
    public Object open() throws Exception {
        Object res;
        Map item = (Map)this.getSelectedEntity();
        if (item == null) {
            return null;
        }
        Node node = this.getNode();
        if (node == null) {
            return null;
        }
        if (this.parentController != null && (res = this.parentController.openItem(item)) != null) {
            if (res instanceof Opener) {
                Opener op = (Opener)res;
                if (!(op.getTarget() + "").toLowerCase().matches("window|popup")) {
                    op.setTarget("popup");
                }
                return op;
            }
            return res;
        }
        String itemfiletype = this.getString(item, "_filetype");
        if (itemfiletype == null || itemfiletype.length() == 0) {
            itemfiletype = this.getString(item, "filetype");
        }
        if (itemfiletype != null && itemfiletype.length() > 0) {
            String invtype = itemfiletype.toLowerCase() + ":open";
            Invoker invoker = this.actionsProvider.getInvoker(node, invtype);
            if (invoker == null) {
                System.out.println("No available file type handler (" + invtype + ")");
                MsgBox.alert((Object)"No access privilege for this item. Please contact your administrator.");
                return null;
            }
            Map map = this.createOpenerParams();
            map.put("node", node.getItem());
            map.put("entity", item);
            return this.actionsProvider.toOpener(invoker, map, node);
        }
        List list = node.getPropertyList("Invoker.openlist");
        if (list != null && !list.isEmpty()) {
            Map map = this.createOpenerParams();
            map.put("node", node.getItem());
            map.put("entity", item);
            return this.actionsProvider.toOpener((Invoker)list.get(0), map, node);
        }
        String dfiletype = this.parentController.getDefaultFileType();
        Invoker invoker = (Invoker)node.getProperty("Invoker.defaultOpen");
        if (invoker == null && dfiletype != null && dfiletype.length() > 0) {
            String invtype = dfiletype.toLowerCase() + ":open";
            invoker = this.actionsProvider.getInvoker(node, invtype);
            if (invoker == null) {
                System.out.println("No available file type handler (" + invtype + ")");
                MsgBox.alert((Object)"No access privilege for this item. Please contact your administrator.");
                return null;
            }
            node.setProperty("Invoker.defaultOpen", (Object)invoker);
        }
        if (invoker != null) {
            Map map = this.createOpenerParams();
            map.put("node", node.getItem());
            map.put("entity", item);
            return this.actionsProvider.toOpener(invoker, map, node);
        }
        if (!node.isLeaf() && this.getString(item, "objid") != null) {
            node.loadItems();
            Node selNode = null;
            String srcid = this.getString(item, "objid");
            List nodes = node.getItems();
            for (Node cnode : nodes) {
                String oid;
                Object citem = cnode.getItem();
                if (!(citem instanceof Map) || (oid = this.getString((Map)citem, "objid")) == null || !oid.equals(srcid)) continue;
                selNode = cnode;
                break;
            }
            if (selNode != null) {
                selNode.open();
            }
        }
        return null;
    }

    @Override
    public Opener create() throws Exception {
        Node node = this.getNode();
        if (node == null) {
            return null;
        }
        List list = node.getPropertyList("Invoker.createlist");
        if (list == null || list.isEmpty()) {
            System.out.println("No available file type handler");
            return null;
        }
        PopupMenuOpener opener = new PopupMenuOpener();
        opener.setExecuteOnSingleResult(true);
        for (Invoker invoker : list) {
            Map map = this.createOpenerParams();
            map.put("node", node.getItem());
            Object fileTypeObject = invoker.getProperties().get("Node.fileTypeObject");
            if (fileTypeObject != null) {
                map.put("filetype", fileTypeObject);
            }
            opener.add((Object)this.actionsProvider.toOpener(invoker, map, node));
        }
        return opener;
    }

    public Object edit() throws Exception {
        Node node = this.getNode();
        if (node == null) {
            return null;
        }
        Invoker invoker = (Invoker)node.getProperty("Invoker.edit");
        if (invoker == null) {
            System.out.println("No available file type handler");
            return null;
        }
        Map map = this.createOpenerParams();
        map.put("node", node.getItem());
        map.put("entity", node.getItem());
        return this.actionsProvider.toOpener(invoker, map, node);
    }

    public void refresh() {
        super.refresh();
        Node node = this.getNode();
        if (node != null) {
            node.reloadItems();
        }
    }

    @Override
    protected Map createOpenerParams() {
        Map params = super.createOpenerParams();
        params.put("listModelHandler", new ListModelHandlerImpl());
        return params;
    }

    @Override
    protected void dataChanged(Object stat) {
        super.dataChanged(stat);
        if (this.parentController == null) {
            return;
        }
        Binding binding = this.parentController.getBinding();
        if (binding == null) {
            return;
        }
        binding.refresh("title");
    }

    public ActionsProvider getActionsProvider() {
        return this.actionsProvider;
    }

    private class DefaultIconColumnHandler
    extends IconColumnHandler {
        ExplorerViewListController root;

        private DefaultIconColumnHandler() {
            this.root = ExplorerViewListController.this;
        }

        public Object getValue(Object rowValue, Object columnValue) {
            if (rowValue instanceof Map) {
                Map map = (Map)rowValue;
                String filetype = this.root.getString(map, "filetype");
                if (filetype == null) {
                    return "default_file";
                }
                String context = this.root.parentController == null ? null : this.root.parentController.getContext();
                String iconpath = "images/explorer/" + context + "/" + filetype + ".png";
                Icon anIcon = ImageIconSupport.getInstance().getIcon(iconpath.toLowerCase());
                if (anIcon == null) {
                    try {
                        anIcon = UIManager.getLookAndFeelDefaults().getIcon("Tree.closedIcon");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return anIcon;
            }
            return null;
        }
    }

    private class ListModelHandlerImpl
    implements ListModelHandler {
        ExplorerViewListController root;

        private ListModelHandlerImpl() {
            this.root = ExplorerViewListController.this;
        }

        @Override
        public Object getSelectedEntity() {
            return this.root.getSelectedEntity();
        }

        @Override
        public void addItem(Object data) {
            this.root.addItem(data);
        }

        @Override
        public void updateItem(Object data) {
            this.root.updateItem(data);
        }

        @Override
        public void removeItem(Object data) {
            this.root.removeItem(data);
        }
    }

    private class DefaultListService
    implements ListService {
        private DefaultListService() {
        }

        @Override
        public List<Map> getColumns(Map params) {
            ArrayList<Map> columns = new ArrayList<Map>();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", "caption");
            map.put("caption", "Name");
            columns.add(map);
            return columns;
        }

        @Override
        public List getList(Map params) {
            return new ArrayList();
        }
    }

    private class ActionInvoker
    extends Action {
        ExplorerViewListController root;
        private Invoker invoker;

        ActionInvoker(Invoker invoker) {
            this.root = ExplorerViewListController.this;
            this.invoker = invoker;
            this.setName(invoker.getAction());
            this.setCaption(invoker.getCaption());
            this.setIcon(this.getString("icon"));
            this.setVisibleWhen(this.getString("visibleWhen"));
            this.setMnemonic(this.getChar("mnemonic"));
            this.setTooltip(this.getString("tooltip"));
            Boolean bool = this.getBoolean("immediate");
            if (bool != null) {
                this.setImmediate(bool);
            }
            if ((bool = this.getBoolean("showCaption")) != null) {
                this.setShowCaption(bool);
            }
            this.getProperties().putAll(invoker.getProperties());
            String depends = this.getString("depends");
            if (depends == null || depends.length() == 0) {
                this.getProperties().put("depends", "listHandler.selectedEntity");
            }
        }

        public Object execute() {
            Node node = this.root.getNode();
            Map map = this.root.createOpenerParams();
            map.put("node", node.getItem());
            map.put("entity", (Map)this.root.getSelectedEntity());
            return ExplorerViewListController.this.actionsProvider.toOpener(this.invoker, map, node);
        }

        private String getString(String name) {
            if (this.invoker == null || this.invoker.getProperties() == null) {
                return null;
            }
            Object ov = this.invoker.getProperties().get(name);
            return ov == null ? null : ov.toString();
        }

        private char getChar(String name) {
            String sv = this.getString(name);
            if (sv == null || sv.trim().length() == 0) {
                return '\u0000';
            }
            return sv.trim().charAt(0);
        }

        private Boolean getBoolean(String name) {
            String sv = this.getString(name);
            if (sv == null || sv.length() == 0) {
                return null;
            }
            return "true".equalsIgnoreCase(sv);
        }
    }

    private class ActionsProvider {
        private ExpressionResolver resolver = ExpressionResolver.getInstance();

        private ActionsProvider() {
        }

        List<Invoker> getInvokers(Node node, String invokerType) {
            try {
                return InvokerUtil.lookup((String)invokerType);
            }
            catch (Throwable t) {
                System.out.println("[WARN] error lookup '" + invokerType + "' caused by " + t.getMessage());
                return new ArrayList<Invoker>();
            }
        }

        Invoker getInvoker(Node node, String invokerType) {
            List<Invoker> list = this.getInvokers(node, invokerType);
            return list.isEmpty() ? null : list.get(0);
        }

        Opener toOpener(Invoker invoker, Map params, Node node) {
            Opener a;
            String target;
            Object nodeTitle = invoker.getProperties().get("formTitle");
            if (nodeTitle != null) {
                params.put("nodeTitle", nodeTitle);
            }
            if (!(target = (a = InvokerUtil.createOpener((Invoker)invoker, (Map)params)).getTarget() + "").matches("window|popup|process|_window|_popup|_process")) {
                a.setTarget("popup");
            }
            return a;
        }
    }
}

