/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.common;

import com.rameses.osiris2.client.InvokerProxy;
import com.rameses.osiris2.common.ReportParameterLoader;
import com.rameses.osiris2.reports.ReportModel;
import com.rameses.osiris2.reports.SubReport;
import com.rameses.rcp.common.FormPanelModel;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.service.jdbc.DBServiceDriver;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;

public abstract class DBReportModel {
    private Map params = new HashMap();
    private String mode = "init";
    private boolean dynamic;
    private ReportModelImpl report = new ReportModelImpl();
    private FormPanelModelImpl fpModel = new FormPanelModelImpl();
    private ClientContext currentContext;
    private ReportParamServiceProxy svcproxy;

    public abstract String getReportName();

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public SubReport[] getSubReports() {
        return null;
    }

    public Map getQuery() {
        return this.params;
    }

    public String getContext() {
        return null;
    }

    public String getCluster() {
        return null;
    }

    public String back() {
        this.setMode("init");
        return "default";
    }

    public String viewReport() {
        this.report.createReport();
        return "report";
    }

    public String preview() {
        String outcome = this.viewReport();
        this.setMode("view");
        return outcome;
    }

    public void reload() {
        this.report.reload();
    }

    public void print() {
        this.print(true);
    }

    public void print(boolean withPrintDialog) {
        this.report.print(withPrintDialog);
    }

    public Object getReport() {
        return this.report;
    }

    public List getFormControls() {
        return null;
    }

    public Object getFormControl() {
        return this.fpModel;
    }

    protected void afterLoadReportParams(Map conf) {
        HashMap<String, Map> invparams = new HashMap<String, Map>();
        invparams.put("params", conf);
        new ReportParameterLoader().load(invparams);
    }

    private ClientContext getCurrentContext() {
        if (this.currentContext == null) {
            this.currentContext = ClientContext.getCurrentContext();
        }
        return this.currentContext;
    }

    private ReportParamServiceProxy getServiceProxy() {
        if (this.svcproxy == null) {
            this.svcproxy = (ReportParamServiceProxy)InvokerProxy.getInstance().create("ReportParameterService", ReportParamServiceProxy.class);
        }
        return this.svcproxy;
    }

    private class JReportInfo {
        private Map params;
        private String connString;

        public JReportInfo(Map params, String connString) {
            this.params = params;
            this.connString = connString;
        }

        public Map getParams() {
            return this.params;
        }

        public JasperPrint fillReport(JasperReport report) {
            Connection conn = null;
            try {
                conn = DriverManager.getConnection(this.connString);
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, (Map)this.getParams(), (Connection)conn);
                return jasperPrint;
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
                throw new RuntimeException(sqle.getMessage(), sqle);
            }
            catch (JRException ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.getMessage(), ex);
            }
            finally {
                try {
                    conn.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private class ReportModelImpl
    extends ReportModel {
        DBReportModel root;
        JReportInfo reportInfo;
        JasperReport mainReport;
        JasperPrint reportOutput;

        private ReportModelImpl() {
            this.root = DBReportModel.this;
        }

        public Object getReportData() {
            return null;
        }

        public String getReportName() {
            return this.root.getReportName();
        }

        public Map getParameters() {
            return this.root.getQuery();
        }

        public SubReport[] getSubReports() {
            return this.root.getSubReports();
        }

        public JasperPrint getReport() {
            return this.reportOutput;
        }

        public void reload() {
            if (this.reportInfo == null) {
                this.reportOutput = this.createReport();
            } else {
                JasperReport jreport = this.loadMainReport();
                this.reportOutput = this.reportInfo.fillReport(jreport);
            }
            if (this.provider != null) {
                this.provider.reload();
            }
        }

        JasperPrint createReport() {
            JasperPrint jprint;
            try {
                Class.forName(DBServiceDriver.class.getName());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            this.mainReport = this.loadMainReport();
            HashMap<String, CustomReportClassLoader> conf = new HashMap<String, CustomReportClassLoader>();
            this.loadSubReport(conf);
            this.loadReportParams(conf);
            String parentName = "";
            String rptName = this.getReportName();
            if (rptName.indexOf("/") > 0) {
                parentName = rptName.substring(0, rptName.lastIndexOf("/"));
            }
            conf.put("REPORT_CLASS_LOADER", new CustomReportClassLoader(parentName));
            this.root.afterLoadReportParams(conf);
            Map env = ClientContext.getCurrentContext().getAppEnv();
            String appUrl = env.get("app.host") + "";
            String appContext = this.root.getContext();
            String appCluster = this.root.getCluster();
            if (appContext == null) {
                appContext = env.get("app.context") + "";
            }
            if (appCluster == null) {
                appCluster = env.get("app.cluster") + "";
            }
            String surl = "jdbc:rameses://" + appUrl + "/" + appCluster + "/" + appContext;
            JReportInfo jrpt = new JReportInfo(conf, surl);
            this.reportOutput = jprint = jrpt.fillReport(this.mainReport);
            this.reportInfo = jrpt;
            return this.reportOutput;
        }
    }

    private class FormPanelModelImpl
    extends FormPanelModel {
        DBReportModel root;

        private FormPanelModelImpl() {
            this.root = DBReportModel.this;
        }

        public List<Map> getControlList() {
            return this.root.getFormControls();
        }
    }

    public static interface ReportParamServiceProxy {
        public Map getStandardParameter();
    }

    public class CustomReportClassLoader
    extends ClassLoader {
        private String parentName;

        public CustomReportClassLoader(String n) {
            this.parentName = n;
            if (this.parentName.trim().length() > 0) {
                this.parentName = this.parentName + "/";
            }
        }

        @Override
        public URL getResource(String name) {
            return this.getClass().getClassLoader().getResource(this.parentName + name);
        }
    }
}

