/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.common;

import com.rameses.rcp.common.Action;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ActionBuilder {
    private List<Action> actions = new ArrayList<Action>();

    public List<Action> getActions() {
        return this.actions;
    }

    public void clear() {
        this.actions.clear();
    }

    public Action add(String name, String caption, String icon) {
        return this.add(name, caption, icon, null);
    }

    public Action add(String name, String caption, String icon, String shortcut) {
        return this.add(name, caption, icon, shortcut, '\u0000');
    }

    public Action add(String name, String caption, String icon, String shortcut, char mnemonic) {
        return this.add(name, caption, icon, shortcut, mnemonic, null);
    }

    public Action add(String name, String caption, String icon, String shortcut, char mnemonic, String visibleWhen) {
        return this.add(name, caption, icon, shortcut, mnemonic, null, false);
    }

    public Action add(Map params) {
        if (params == null) {
            return null;
        }
        String command = this.getString(params, "action");
        String caption = this.getString(params, "caption");
        String icon = this.getString(params, "icon");
        String shortcut = this.getString(params, "shortcut");
        char mnemonic = this.getChar(params, "mnemonic");
        String visibleWhen = this.getString(params, "visibleWhen");
        Boolean immediate = this.getBoolean(params, "immediate");
        if (immediate == null) {
            immediate = Boolean.FALSE;
        }
        return this.add(command, caption, icon, shortcut, mnemonic, visibleWhen, immediate);
    }

    public Action add(String name, String caption, String icon, String shortcut, char mnemonic, String visibleWhen, boolean immediate) {
        Action a = new Action(name, caption, icon, mnemonic);
        if (shortcut != null) {
            a.getProperties().put("shortcut", shortcut);
        }
        if (visibleWhen != null) {
            a.setVisibleWhen(visibleWhen);
        }
        a.setImmediate(immediate);
        this.actions.add(a);
        return a;
    }

    private String getString(Map map, Object key) {
        Object value = map == null ? null : (Object)map.get(key);
        return value == null ? null : value.toString();
    }

    private char getChar(Map map, Object key) {
        String str = this.getString(map, key);
        if (str == null || str.length() == 0) {
            return '\u0000';
        }
        return str.charAt(0);
    }

    private Boolean getBoolean(Map map, Object key) {
        Object o;
        Object object = o = map == null ? null : (Object)map.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        boolean b = o.toString().equalsIgnoreCase("true");
        return new Boolean(b);
    }
}

