/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.jfx;

import com.rameses.rcp.common.ClickActionEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class WebViewPane
extends JPanel {
    private static final Object LOAD_VIEW_LOCKED = new Object();
    private JFXPanel fxp;
    private WebView wv;
    private JLabel stat;
    private boolean contextMenuEnabled;
    private Object bindingBean;

    public WebViewPane() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(300, 250));
        this.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180), 1));
        this.setBackground(Color.WHITE);
        this.contextMenuEnabled = false;
        this.stat = new JLabel("");
        this.fxp = new JFXPanelImpl();
        this.add((Component)this.fxp, "Center");
    }

    public boolean isContextMenuEnabled() {
        return this.contextMenuEnabled;
    }

    public void setContextMenuEnabled(boolean contextMenuEnabled) {
        this.contextMenuEnabled = contextMenuEnabled;
    }

    public void setBindingBean(Object bindingBean) {
        this.bindingBean = bindingBean;
    }

    public void loadView(Object value) {
        Platform.runLater((Runnable)new WebViewLoader(value));
    }

    protected void processAction(String name, Map param) {
    }

    protected void processAction(ClickActionEvent cae) {
    }

    protected void onSucceeded(WebEngine we) {
    }

    private void updateStat(String text) {
        if (text == null) {
            text = "";
        }
        if (text.trim().length() > 0) {
            this.stat.setText(" " + text + "                    ");
        } else {
            this.stat.setText("");
        }
        this.fxp.repaint();
    }

    private class ClickActionHandler
    implements EventListener {
        private String tagName;

        private ClickActionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(org.w3c.dom.events.Event e) {
            String domEventType = e.getType();
            if ("click".equals(domEventType) && e.getTarget() instanceof Node) {
                Node node = (Node)((Object)e.getCurrentTarget());
                NamedNodeMap attrs = node.getAttributes();
                HashMap<String, String> param = new HashMap<String, String>();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    node = attrs.item(i);
                    param.put(node.getNodeName(), node.getNodeValue());
                }
                URL url = this.buildLocationURL();
                Object ohref = param.get("href");
                String shref = ohref == null ? "" : ohref.toString();
                StringBuilder sb = new StringBuilder();
                if (url == null) {
                    sb.append(shref);
                } else {
                    sb.append(url.getProtocol()).append("://");
                    if ("file".equals(url.getProtocol())) {
                        sb.append("/");
                    }
                    sb.append(url.getAuthority());
                    if (shref.length() != 0) {
                        if (shref.startsWith("/")) {
                            sb.append(shref);
                        } else {
                            sb.append(url.getPath());
                            if (sb.charAt(sb.length() - 1) != '/') {
                                sb.append("/");
                            }
                            sb.append(shref);
                        }
                    }
                }
                ClickActionEvent cae = new ClickActionEvent(this.tagName, sb.toString(), param);
                try {
                    WebViewPane.this.processAction(cae);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    if (cae.isConsumed()) {
                        e.stopPropagation();
                        e.preventDefault();
                    }
                }
            }
        }

        private URL buildLocationURL() {
            try {
                return new URL(WebViewPane.this.wv.getEngine().getLocation());
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
    }

    private class LinkActionHandler
    implements EventListener {
        private LinkActionHandler() {
        }

        @Override
        public void handleEvent(org.w3c.dom.events.Event e) {
            String domEventType = e.getType();
            if ("click".equals(domEventType)) {
                e.stopPropagation();
                e.preventDefault();
                if (e.getTarget() instanceof Node) {
                    Node node = (Node)((Object)e.getCurrentTarget());
                    NamedNodeMap attrs = node.getAttributes();
                    HashMap<String, String> param = new HashMap<String, String>();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        node = attrs.item(i);
                        param.put(node.getNodeName(), node.getNodeValue());
                    }
                    this.fireProcessAction(param);
                }
            }
        }

        private void fireProcessAction(Map param) {
            try {
                Object o = param.get("action");
                String aname = o == null ? null : o.toString();
                WebViewPane.this.processAction(aname, param);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private class WebViewLoader
    implements Runnable {
        WebViewPane root;
        private Object value;

        WebViewLoader(Object value) {
            this.root = WebViewPane.this;
            this.value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = LOAD_VIEW_LOCKED;
            synchronized (object) {
                this.runImpl();
            }
        }

        private void runImpl() {
            if (this.value == null) {
                this.value = "";
            }
            if (this.value.toString().length() > 0) {
                WebViewPane.this.updateStat("Processing request...");
            } else {
                WebViewPane.this.updateStat("");
            }
            if (WebViewPane.this.wv == null) {
                WebViewPane.this.wv = new WebView();
                WebViewPane.this.wv.getEngine().setOnAlert(new EventHandler(){

                    public void handle(Event t) {
                        if (t instanceof WebEvent) {
                            WebEvent we = (WebEvent)t;
                            String msg = we.getData() + "";
                            JOptionPane.showMessageDialog(WebViewLoader.this.root, msg, "Message", 1);
                        }
                    }
                });
                WebViewPane.this.wv.getEngine().setConfirmHandler(new Callback(){

                    public Object call(Object p) {
                        int opt = JOptionPane.showConfirmDialog(WebViewLoader.this.root, p + "", "Confirm", 0);
                        return opt == 0;
                    }
                });
                WebViewPane.this.wv.getEngine().setPromptHandler(new Callback(){

                    public Object call(Object p) {
                        if (p instanceof PromptData) {
                            PromptData pd = (PromptData)p;
                            return JOptionPane.showInputDialog(WebViewLoader.this.root, pd.getMessage() + "", pd.getDefaultValue());
                        }
                        return null;
                    }
                });
                Worker worker = WebViewPane.this.wv.getEngine().getLoadWorker();
                worker.stateProperty().addListener(new ChangeListener(){

                    public void changed(ObservableValue ov, Object oldValue, Object newValue) {
                        WebEngine we = WebViewPane.this.wv.getEngine();
                        if (newValue == Worker.State.READY) {
                            WebViewPane.this.updateStat("Connecting...");
                        } else if (newValue == Worker.State.SCHEDULED) {
                            WebViewPane.this.updateStat("Connecting...");
                        } else if (newValue == Worker.State.RUNNING) {
                            WebViewPane.this.updateStat("Waiting...");
                        } else if (newValue == Worker.State.CANCELLED) {
                            WebViewPane.this.updateStat("Cancelled");
                        } else if (newValue == Worker.State.FAILED) {
                            Throwable err = we.getLoadWorker().getException();
                            WebViewPane.this.updateStat("Failed: " + (err == null ? "" : err.getMessage()));
                        }
                        if (newValue == Worker.State.SUCCEEDED) {
                            WebViewPane.this.updateStat("Hooking events please wait...");
                            Object owin = we.executeScript("window");
                            if (owin instanceof JSObject) {
                                JSObject jso = (JSObject)owin;
                                jso.setMember("bindingBean", WebViewLoader.this.root.bindingBean);
                            }
                            Document doc = WebViewPane.this.wv.getEngine().getDocument();
                            WebViewLoader.this.hookActionEvent(doc.getElementsByTagName("a"));
                            WebViewLoader.this.hookActionEvent(doc.getElementsByTagName("button"));
                            WebViewLoader.this.hookActionEvent(doc.getElementsByTagName("input"));
                            WebViewPane.this.updateStat(null);
                            WebViewLoader.this.root.onSucceeded(we);
                        }
                    }
                });
                worker.messageProperty().addListener(new ChangeListener(){

                    public void changed(ObservableValue ov, Object oldValue, Object newValue) {
                        String msg = newValue == null ? "" : newValue.toString();
                        WebViewPane.this.updateStat(msg);
                    }
                });
                WebViewPane.this.fxp.setScene(new Scene((Parent)WebViewPane.this.wv));
            }
            StringBuilder styles = new StringBuilder();
            styles.append(" -fx-context-menu-enabled: " + WebViewPane.this.isContextMenuEnabled() + "; ");
            styles.append(" -fx-font-family: Arial; ");
            WebViewPane.this.wv.setStyle(styles.toString());
            WebEngine we = WebViewPane.this.wv.getEngine();
            if (this.value instanceof URL) {
                we.load(this.value.toString());
            } else if (this.value.toString().matches("[a-zA-Z]{1,}://.*")) {
                we.load(this.value.toString());
            } else {
                we.loadContent(this.value.toString());
            }
        }

        private void hookActionEvent(NodeList nodes) {
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element) || !(node instanceof EventTarget)) continue;
                Element elem = (Element)node;
                String tagName = node.getNodeName();
                String href = null;
                String actionName = null;
                String stype = elem.getAttribute("type") + "";
                if ("A".equalsIgnoreCase(node.getNodeName())) {
                    actionName = elem.getAttribute("action");
                    href = elem.getAttribute("href");
                    href = href == null ? null : href.trim();
                } else if ("BUTTON".equalsIgnoreCase(node.getNodeName())) {
                    actionName = elem.getAttribute("action");
                } else if ("INPUT".equalsIgnoreCase(node.getNodeName()) && "button".equalsIgnoreCase(stype)) {
                    actionName = elem.getAttribute("action");
                }
                if (actionName != null && actionName.trim().length() > 0) {
                    EventTarget et = (EventTarget)((Object)node);
                    et.addEventListener("click", new LinkActionHandler(), false);
                    continue;
                }
                if (href == null || href.length() <= 1) continue;
                ClickActionHandler cah = new ClickActionHandler();
                cah.tagName = tagName;
                EventTarget et = (EventTarget)((Object)node);
                et.addEventListener("click", cah, false);
            }
        }
    }

    private class JFXPanelImpl
    extends JFXPanel {
        private JFXPanelImpl() {
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2;
            super.paintComponent(g);
            String text = WebViewPane.this.stat.getText();
            if (text == null || text.trim().length() == 0) {
                return;
            }
            Dimension dim = WebViewPane.this.stat.getPreferredSize();
            int dh = dim.height + 5;
            Insets margin = this.getInsets();
            int x = margin.left + 1;
            int y = this.getHeight() - margin.bottom - dh - 1;
            y = Math.max(y, margin.top);
            AlphaComposite alpha = this.createAlphaComposite(0.5f);
            if (alpha != null) {
                g2 = (Graphics2D)g.create();
                g2.setComposite(alpha);
                g2.fillRect(x, y, dim.width, dh);
                g2.dispose();
            }
            g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.WHITE);
            g2.drawString(WebViewPane.this.stat.getText(), x + 2, y + 13);
            g2.dispose();
        }

        private AlphaComposite createAlphaComposite(float alpha) {
            try {
                return AlphaComposite.getInstance(3, alpha);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

