/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.reports.ui;

import com.rameses.osiris2.reports.ReportModel;
import com.rameses.osiris2.reports.ReportOutput;
import com.rameses.osiris2.reports.ReportUtil;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.BreakException;
import com.rameses.util.ValueUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;

public class XReportPanel
extends JPanel
implements UIControl {
    private Binding binding;
    private String[] depends;
    private int index;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private ReportModel model;
    ProviderImpl provider;
    private JButton btnBack;
    private JButton btnEdit;
    private JButton btnSync;

    public XReportPanel() {
        super.setLayout(new BorderLayout());
        if (Beans.isDesignTime()) {
            super.setPreferredSize(new Dimension(40, 40));
            super.setOpaque(true);
            super.setBackground(Color.LIGHT_GRAY);
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public void setStyle(Map props) {
    }

    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare((UIControl)this, (Object)o);
    }

    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public void load() {
    }

    public void refresh() {
        this.render();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean((Object)this.getBinding().getBean(), (String)whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    public int getStretchWidth() {
        return this.stretchWidth;
    }

    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    public int getStretchHeight() {
        return this.stretchHeight;
    }

    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    private void render() {
        if (ValueUtil.isEmpty((Object)this.getName())) {
            throw new IllegalStateException("Report Panel name must be provided");
        }
        Object value = UIControlUtil.getBeanValue((UIControl)this);
        this.model = value instanceof ReportModel ? (ReportModel)value : null;
        JasperPrint jasperPrint = null;
        if (this.model != null) {
            this.model.setProvider(this.getProviderImpl());
            jasperPrint = this.model.getReport();
        } else if (value instanceof ReportOutput) {
            jasperPrint = ((ReportOutput)value).getOutput();
        } else if (value instanceof JasperPrint) {
            jasperPrint = (JasperPrint)value;
        }
        if (jasperPrint == null) {
            throw new IllegalStateException("No report found at " + this.getName());
        }
        this.loadViewer(jasperPrint, value);
    }

    private void loadViewer(JasperPrint jp, Object value) {
        JRViewer jrv = new JRViewer(jp);
        new Customizer(jrv, value).customize();
        this.removeAll();
        this.add((Component)jrv);
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void doReload() {
        if (this.model != null) {
            this.model.reload();
        }
    }

    private void doBack() {
        try {
            Object outcome;
            Object object = outcome = this.model == null ? null : this.model.back();
            if (outcome == null) {
                return;
            }
            this.getBinding().fireNavigation(outcome);
        }
        catch (Throwable t) {
            MsgBox.alert((Object)t);
        }
    }

    private void doEdit() {
        try {
            Object outcome;
            Object object = outcome = this.model == null ? null : this.model.edit();
            if (outcome == null) {
                return;
            }
            this.getBinding().fireNavigation(outcome);
        }
        catch (Throwable t) {
            MsgBox.alert((Object)t);
        }
    }

    ProviderImpl getProviderImpl() {
        if (this.provider == null) {
            this.provider = new ProviderImpl();
        }
        return this.provider;
    }

    private JButton getBackButton() {
        if (this.btnBack == null) {
            this.btnBack = new JButton();
            this.btnBack.setMargin(new Insets(2, 2, 2, 2));
            this.btnBack.setMnemonic('b');
            this.btnBack.setToolTipText("Go back");
            this.btnBack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XReportPanel.this.doBack();
                }
            });
            try {
                URL url = XReportPanel.class.getResource("images/arrow_left.png");
                this.btnBack.setIcon(new ImageIcon(url));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.btnBack;
    }

    private JButton getEditButton() {
        if (this.btnEdit == null) {
            this.btnEdit = new JButton();
            this.btnEdit.setMargin(new Insets(2, 2, 2, 2));
            this.btnEdit.setMnemonic('e');
            this.btnEdit.setToolTipText("Edit Report");
            this.btnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XReportPanel.this.doEdit();
                }
            });
            try {
                URL url = XReportPanel.class.getResource("images/edit.png");
                this.btnEdit.setIcon(new ImageIcon(url));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.btnEdit;
    }

    private JButton getSyncButton() {
        if (this.btnSync == null) {
            this.btnSync = new JButton();
            this.btnSync.setMargin(new Insets(2, 2, 2, 2));
            this.btnSync.setMnemonic('r');
            this.btnSync.setToolTipText("Reload Report");
            this.btnSync.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XReportPanel.this.doReload();
                }
            });
            try {
                URL url = XReportPanel.class.getResource("images/sync.png");
                this.btnSync.setIcon(new ImageIcon(url));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.btnSync;
    }

    private class PrintActionHandler
    implements ActionListener {
        private ReportModel model;
        private AbstractButton button;
        private List<ActionListener> actions = new ArrayList<ActionListener>();

        PrintActionHandler(ReportModel model) {
            this.model = model;
        }

        void install(AbstractButton button) {
            this.button = button;
            this.actions = new ArrayList<ActionListener>();
            if (button != null) {
                ActionListener[] values;
                for (ActionListener al : values = button.getActionListeners()) {
                    if (al == null) continue;
                    if (al instanceof PrintActionHandler) {
                        button.removeActionListener(al);
                        continue;
                    }
                    button.removeActionListener(al);
                    this.actions.add(al);
                }
                button.addActionListener(this);
            }
        }

        boolean beforeExecute() {
            return this.model == null ? true : this.model.beforePrint();
        }

        void afterExecute() {
            if (this.model != null) {
                this.model.afterPrint();
            }
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            try {
                if (!this.beforeExecute()) {
                    return;
                }
            }
            catch (BreakException be) {
                return;
            }
            for (ActionListener al : this.actions) {
                al.actionPerformed(e);
            }
            try {
                this.afterExecute();
            }
            catch (BreakException breakException) {
                // empty catch block
            }
        }
    }

    private class CustomLayout
    implements LayoutManager {
        private Component[] systemComponents;
        private Component[] components;
        private PrintActionHandler printHandler;
        private boolean allowSave = false;
        private boolean allowPrint = true;

        private CustomLayout() {
        }

        void setComponents(Component[] components) {
            this.components = components;
            if (components != null && components.length > 0) {
                Component c0 = components[0];
                c0.setVisible(this.allowSave);
                c0.setEnabled(this.allowSave);
                this.setMnemonic(c0, 's');
                if (components.length > 1) {
                    Component c1 = components[1];
                    c1.setVisible(this.allowPrint);
                    c1.setEnabled(this.allowPrint);
                    this.setMnemonic(c1, 'p');
                    if (c1 instanceof AbstractButton && this.printHandler != null) {
                        AbstractButton btn = (AbstractButton)c1;
                        this.printHandler.install(btn);
                    }
                }
            }
        }

        void setSystemComponents(Component[] systemComponents) {
            this.systemComponents = systemComponents;
        }

        void setMnemonic(Component c, char key) {
            if (c == null || key == '\u0000') {
                return;
            }
            if (!(c instanceof JButton)) {
                return;
            }
            ((JButton)c).setMnemonic(key);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim;
                Component c;
                int i;
                int w = 0;
                int h = 0;
                if (this.systemComponents != null) {
                    for (i = 0; i < this.systemComponents.length; ++i) {
                        c = this.systemComponents[i];
                        if (c == null || !c.isVisible()) continue;
                        dim = c.getPreferredSize();
                        w += dim.width;
                        h = Math.max(h, dim.height);
                    }
                }
                if (this.components != null) {
                    for (i = 0; i < this.components.length; ++i) {
                        c = this.components[i];
                        if (!c.isVisible()) continue;
                        dim = c.getPreferredSize();
                        w += dim.width;
                        h = Math.max(h, dim.height);
                    }
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim;
                Component c;
                int i;
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                if (this.systemComponents != null) {
                    for (i = 0; i < this.systemComponents.length; ++i) {
                        c = this.systemComponents[i];
                        if (c == null || !c.isVisible()) continue;
                        dim = c.getPreferredSize();
                        c.setBounds(x, y, dim.width, h);
                        x += dim.width;
                    }
                }
                if (this.components != null) {
                    for (i = 0; i < this.components.length; ++i) {
                        c = this.components[i];
                        if (c == null || !c.isVisible()) continue;
                        dim = c.getPreferredSize();
                        c.setBounds(x, y, dim.width, h);
                        x += dim.width;
                    }
                }
            }
        }
    }

    private class Customizer {
        private JRViewer jviewer;
        private ReportModel model;
        private boolean allowSave = false;
        private boolean allowPrint = true;
        private boolean allowEdit = false;
        private boolean allowBack = false;

        Customizer(JRViewer jviewer, Object value) {
            this.jviewer = jviewer;
            if (value instanceof ReportModel) {
                this.model = (ReportModel)value;
                this.allowPrint = this.model.isAllowPrint();
                this.allowSave = this.model.isAllowSave();
                this.allowEdit = this.model.isAllowEdit();
                this.allowBack = this.model.isAllowBack();
            } else if (value instanceof ReportOutput) {
                ReportOutput out = (ReportOutput)value;
                this.allowPrint = out.isAllowPrint();
                this.allowSave = out.isAllowSave();
                this.allowEdit = out.isAllowEdit();
                this.allowBack = out.isAllowBack();
            }
        }

        void customize() {
            Component comp;
            if (this.jviewer == null) {
                return;
            }
            LayoutManager lm = this.jviewer.getLayout();
            if (lm instanceof BorderLayout && (comp = ((BorderLayout)lm).getLayoutComponent("North")) instanceof Container) {
                Container con = (Container)comp;
                if (con.getLayout() instanceof CustomLayout) {
                    return;
                }
                JButton sysbtnback = XReportPanel.this.getBackButton();
                ((Component)sysbtnback).setVisible(this.allowBack);
                sysbtnback.setName("sysbtnback");
                JButton sysbtnedit = XReportPanel.this.getEditButton();
                ((Component)sysbtnedit).setVisible(this.allowEdit);
                sysbtnedit.setName("sysbtnedit");
                JButton sysbtnsync = XReportPanel.this.getSyncButton();
                ((Component)sysbtnsync).setVisible(this.allowEdit);
                sysbtnsync.setName("sysbtnsync");
                Component spacer = Box.createHorizontalStrut(10);
                spacer.setVisible(this.allowEdit);
                spacer.setName("sysspacer");
                CustomLayout clayout = new CustomLayout();
                clayout.allowSave = this.allowSave;
                clayout.allowPrint = this.allowPrint;
                clayout.printHandler = new PrintActionHandler(this.model);
                clayout.setSystemComponents(new Component[]{sysbtnback, sysbtnedit, sysbtnsync, spacer});
                clayout.setComponents(con.getComponents());
                con.add(sysbtnback);
                con.add(sysbtnedit);
                con.add(sysbtnsync);
                con.add(spacer);
                con.setLayout(clayout);
                if (con instanceof JComponent) {
                    ((JComponent)con).setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
                }
            }
        }
    }

    private class ProviderImpl
    implements ReportModel.Provider {
        XReportPanel root;
        JFileChooser jfc;

        private ProviderImpl() {
            this.root = XReportPanel.this;
            this.jfc = null;
        }

        @Override
        public Object getBinding() {
            return this.root.getBinding();
        }

        @Override
        public File browseFolder() {
            int result;
            if (this.jfc == null) {
                File fdir = ReportUtil.getCustomFolder();
                this.jfc = new JFileChooser(fdir);
                this.jfc.setDialogTitle("Select Report Folder");
                this.jfc.setFileSelectionMode(1);
            }
            if ((result = this.jfc.showOpenDialog(this.root)) == 0) {
                return this.jfc.getSelectedFile();
            }
            return null;
        }

        @Override
        public void reload() {
            if (this.root.model == null) {
                return;
            }
            XReportPanel.this.loadViewer(this.root.model.getReport(), this.root.model);
        }
    }
}

