/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.reports;

import com.rameses.common.PropertyResolver;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.client.Inv;
import com.rameses.osiris2.client.InvokerFilter;
import com.rameses.osiris2.client.InvokerProxy;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.osiris2.reports.ReportDataSource;
import com.rameses.osiris2.reports.ReportDataSourceHelper;
import com.rameses.osiris2.reports.ReportDataUtil;
import com.rameses.osiris2.reports.ReportUtil;
import com.rameses.osiris2.reports.SubReport;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.URLStreamHandlers;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;

public abstract class ReportModel {
    @com.rameses.rcp.annotations.Invoker
    protected Invoker invoker;
    private boolean dynamic = false;
    private boolean allowSave = true;
    private boolean allowPrint = true;
    private boolean allowBack = false;
    private boolean ignorePagination;
    protected final PropertyResolver propertyResolver = PropertyResolver.getInstance();
    private JasperPrint reportOutput;
    private JReportInfo reportInfo;
    private JasperReport mainReport;
    protected Provider provider;
    private File workspacedir;
    private ReportParamServiceProxy svcproxy;

    public abstract Object getReportData();

    public abstract String getReportName();

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isIgnorePagination() {
        return this.ignorePagination;
    }

    public void setIgnorePagination(boolean ignorePagination) {
        this.ignorePagination = ignorePagination;
    }

    public boolean isAllowSave() {
        return this.allowSave;
    }

    public void setAllowSave(boolean allowSave) {
        this.allowSave = allowSave;
    }

    public boolean isAllowPrint() {
        return this.allowPrint;
    }

    public void setAllowPrint(boolean allowPrint) {
        this.allowPrint = allowPrint;
    }

    public boolean isAllowBack() {
        return this.allowBack;
    }

    public void setAllowBack(boolean allowBack) {
        this.allowBack = allowBack;
    }

    public boolean isAllowEdit() {
        return ReportUtil.isDeveloperMode();
    }

    public SubReport[] getSubReports() {
        return null;
    }

    public Map getParameters() {
        return null;
    }

    protected void afterLoadReportParams(Map conf) {
    }

    protected void afterReportData(Object data) {
    }

    public boolean beforePrint() {
        return true;
    }

    public void afterPrint() {
    }

    public JasperReport getMainReport() {
        return null;
    }

    private String getReportNameImpl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReportName());
        if (sb.toString().toLowerCase().endsWith(".jasper") || sb.toString().toLowerCase().endsWith(".jrxml")) {
            return sb.toString();
        }
        sb.append(".jasper");
        return sb.toString();
    }

    protected JasperReport loadMainReport() {
        JasperReport jrpt;
        if (ReportUtil.isDeveloperMode()) {
            this.mainReport = null;
            this.updateWorkspaceDir();
        }
        if ((jrpt = this.getMainReport()) != null) {
            this.mainReport = jrpt;
        } else if (this.mainReport == null || this.isDynamic()) {
            this.mainReport = ReportUtil.getJasperReport(this.getReportNameImpl());
        }
        return this.mainReport;
    }

    protected void loadSubReport(Map conf) {
        SubReport[] subReports = this.getSubReports();
        if (subReports != null) {
            for (SubReport sr : subReports) {
                conf.put(sr.getName(), sr.getReport());
            }
        }
    }

    protected void loadReportParams(Map conf) {
        JRParameter[] jrparams;
        Map params;
        ReportParamServiceProxy reportParamProxy = this.getServiceProxy();
        if (reportParamProxy != null && (params = reportParamProxy.getStandardParameter()) != null) {
            conf.putAll(params);
        }
        if ((params = this.getParameters()) != null) {
            conf.putAll(params);
        }
        Map appenv = ClientContext.getCurrentContext().getAppEnv();
        for (Object key : appenv.keySet()) {
            conf.put("ENV_" + key.toString().toUpperCase().replace('.', '_'), appenv.get(key));
        }
        JRParameter[] jRParameterArray = jrparams = this.mainReport == null ? null : this.mainReport.getParameters();
        if (jrparams != null) {
            for (JRParameter jrp : jrparams) {
                String pname = jrp.getName();
                try {
                    if (jrp.isSystemDefined() || pname.indexOf(46) <= 0) continue;
                    Object pvalue = this.propertyResolver.getProperty((Object)conf, pname);
                    conf.put(pname, pvalue);
                }
                catch (Throwable t) {
                    System.out.println("Error on parameter [" + pname + "] caused by " + t.getMessage());
                }
            }
        }
        conf.put("REPORT_UTIL", new ReportDataUtil());
        conf.put("REPORTHELPER", new ReportDataSourceHelper());
        String reportPath = "";
        String rptName = this.getReportNameImpl();
        if (rptName != null && rptName.indexOf("/") > 0) {
            reportPath = rptName.substring(0, rptName.lastIndexOf("/"));
        }
        if (conf.get("REPORT_CLASS_LOADER") == null) {
            conf.put("REPORT_CLASS_LOADER", new CustomReportClassLoader(reportPath));
        }
        conf.put("REPORT_URL_HANDLER_FACTORY", URLStreamHandlers.getFactory());
        if (this.isIgnorePagination()) {
            conf.put("IS_IGNORE_PAGINATION", true);
        }
    }

    private JasperPrint createReport() {
        this.loadMainReport();
        JReportInfo jrpt = this.createJReportInfo();
        JasperPrint jprint = jrpt.fillReport(this.mainReport);
        this.reportInfo = jrpt;
        return jprint;
    }

    public JRDataSource createDataSource() {
        JReportInfo jrpt = this.createJReportInfo();
        return jrpt.createDataSource();
    }

    private JReportInfo createJReportInfo() {
        Object data = this.getReportData();
        this.afterReportData(data);
        Map conf = this.buildReportParameters();
        return new JReportInfo(data, conf);
    }

    public final Map buildReportParameters() {
        HashMap conf = new HashMap();
        this.loadSubReport(conf);
        this.loadReportParams(conf);
        this.afterLoadReportParams(conf);
        return conf;
    }

    public String viewReport() {
        this.reportOutput = this.createReport();
        return "report";
    }

    public void exportToPDF() throws Exception {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(0);
        jfc.setMultiSelectionEnabled(false);
        int opt = 1;
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        opt = win instanceof Frame ? jfc.showSaveDialog((Frame)win) : (win instanceof Dialog ? jfc.showSaveDialog((Dialog)win) : jfc.showSaveDialog(null));
        if (opt == 0) {
            this.exportToPDF(jfc.getSelectedFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToPDF(File file) throws Exception {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.exportToPDF(fos);
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void exportToPDF(OutputStream out) throws Exception {
        JasperPrint jprint = this.createReport();
        JasperExportManager.exportReportToPdfStream((JasperPrint)jprint, (OutputStream)out);
    }

    public void reload() {
        this.reportOutput = this.createReport();
        if (this.provider != null) {
            this.provider.reload();
        }
    }

    public JasperPrint getReport() {
        return this.reportOutput;
    }

    public void print() {
        this.print(true);
    }

    public void printNoDialog() {
        this.print(false);
    }

    public void print(boolean withPrintDialog) {
        try {
            ReportUtil.print(this.createReport(), withPrintDialog);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public List getReportActions() {
        ArrayList<Action> list = new ArrayList<Action>();
        list.add(new Action("_close", "Close", null));
        List<Action> xactions = this.lookupActions("reportActions");
        while (!xactions.isEmpty()) {
            Action a = xactions.remove(0);
            if (this.containsAction(list, a)) continue;
            list.add(a);
        }
        return list;
    }

    private boolean containsAction(List<Action> list, Action a) {
        for (Action aa : list) {
            if (!aa.getName().equals(a.getName())) continue;
            return true;
        }
        return false;
    }

    protected final List<Action> lookupActions(String type) {
        List<Action> actions = new ArrayList();
        try {
            actions = InvokerUtil.lookupActions((String)type, (InvokerFilter)new InvokerFilter(){

                public boolean accept(Invoker o) {
                    return o.getWorkunitid().equals(ReportModel.this.invoker.getWorkunitid());
                }
            });
        }
        catch (Throwable t) {
            System.out.println("[WARN] error lookup actions caused by " + t.getMessage());
        }
        for (int i = 0; i < actions.size(); ++i) {
            Action newAction = actions.get(i).clone();
            actions.set(i, newAction);
        }
        return actions;
    }

    public Object back() {
        return "_close";
    }

    public Object edit() {
        try {
            HashMap<String, ReportModel> params = new HashMap<String, ReportModel>();
            params.put("report", this);
            return Inv.lookupOpener((String)"sysreport:edit", params);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Object getBinding() {
        return this.provider == null ? null : this.provider.getBinding();
    }

    public File getWorkspaceDir() {
        return this.workspacedir;
    }

    public void setWorkspaceDir(File workspacedir) {
        if (workspacedir == null) {
            workspacedir = ReportUtil.getDefaultCustomFolder();
        }
        this.workspacedir = workspacedir;
        ReportUtil.setCustomFolder(workspacedir);
    }

    public void updateWorkspaceDir() {
        if (this.getWorkspaceDir() == null) {
            this.setWorkspaceDir(null);
        }
        ReportUtil.setCustomFolder(this.getWorkspaceDir());
    }

    public File browseFolder() {
        File newdir = null;
        if (this.provider != null) {
            newdir = this.provider.browseFolder();
        }
        this.setWorkspaceDir(newdir);
        return ReportUtil.getCustomFolder();
    }

    public String getReportParameterServiceName() {
        return "ReportParameterService";
    }

    protected ReportParamServiceProxy getServiceProxy() {
        if (this.svcproxy == null) {
            String sname = this.getReportParameterServiceName();
            if (sname == null) {
                return null;
            }
            this.svcproxy = (ReportParamServiceProxy)InvokerProxy.getInstance().create("ReportParameterService", ReportParamServiceProxy.class);
        }
        return this.svcproxy;
    }

    public static interface ReportParamServiceProxy {
        public Map getStandardParameter();
    }

    private class JReportInfo {
        private Object data;
        private Map params;

        public JReportInfo(Object data, Map params) {
            this.data = data;
            this.params = params;
        }

        public Object getData() {
            return this.data;
        }

        public Map getParams() {
            return this.params;
        }

        public JRDataSource createDataSource() {
            if (this.data == null) {
                return new JREmptyDataSource();
            }
            return new ReportDataSource(this.data);
        }

        public JasperPrint fillReport(JasperReport report) {
            JRDataSource ds = this.createDataSource();
            try {
                return JasperFillManager.fillReport((JasperReport)report, (Map)this.getParams(), (JRDataSource)ds);
            }
            catch (JRException ex) {
                ex.printStackTrace();
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
    }

    public static interface Provider {
        public Object getBinding();

        public File browseFolder();

        public void reload();
    }

    class CustomReportClassLoader
    extends ClassLoader {
        private String basepath;

        public CustomReportClassLoader(String basepath) {
            this.basepath = basepath;
            this.basepath = basepath != null && basepath.trim().length() > 0 ? basepath + "/" : "/";
        }

        @Override
        public URL getResource(String name) {
            URL url = ReportUtil.getResource(this.basepath + name);
            if (url != null) {
                return url;
            }
            return this.getClass().getClassLoader().getResource(this.basepath + name);
        }
    }
}

