/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.reports;

import com.rameses.common.PropertyResolver;
import com.rameses.osiris2.reports.QRCodeUtil;
import com.rameses.osiris2.reports.ReportDataSourceHelper;
import com.rameses.util.Base64Cipher;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;

public class ReportDataSource
implements JRRewindableDataSource {
    protected Iterator iterator;
    protected Object currentObject;
    private Object source;
    private PropertyResolver propertyResolver;
    private ReportDataSourceHelper helper;
    private SimpleDateFormat YMD = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat YMD_HMS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ReportDataSource(Object source) {
        this.setSource(source);
        this.propertyResolver = PropertyResolver.getInstance();
    }

    public ReportDataSourceHelper getHelper() {
        return this.helper;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object src) {
        this.source = src;
        this.helper = new ReportDataSourceHelper(this.source);
        this.reset();
    }

    private void reset() {
        Object src = this.getSource();
        if (src == null) {
            this.iterator = new ArrayList().iterator();
        } else if (src instanceof Collection) {
            this.iterator = ((Collection)src).iterator();
        } else {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(src);
            this.iterator = l.iterator();
        }
    }

    public void moveFirst() throws JRException {
        this.reset();
    }

    public boolean next() throws JRException {
        if (this.iterator.hasNext()) {
            this.currentObject = this.iterator.next();
            return true;
        }
        return false;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        Object value = null;
        String fieldName = null;
        try {
            fieldName = jRField.getName();
            if ("_source".equals(fieldName)) {
                return new ReportDataSource(this.getSource());
            }
            value = this.propertyResolver.getProperty(this.currentObject, fieldName);
            if (value == null) {
                return null;
            }
            Class fieldClass = jRField.getValueClass();
            if (value.getClass().toString().endsWith(".JSONNull")) {
                return null;
            }
            if (value.getClass() == byte[].class) {
                if (jRField.getValueClass() == URL.class) {
                    BytesHandler handler = new BytesHandler((byte[])value);
                    return new URL(null, "bytes:///", handler);
                }
                return new ByteArrayInputStream((byte[])value);
            }
            if (value.getClass() == String.class) {
                if (java.util.Date.class.isAssignableFrom(jRField.getValueClass())) {
                    return this.convertDateObject(jRField.getValueClass(), value.toString());
                }
                String str = value.toString();
                if (str.startsWith("qrcode:")) {
                    String newstr = str.substring(7);
                    byte[] bytes = QRCodeUtil.generateQRCode(newstr);
                    if (jRField.getValueClass() == URL.class) {
                        BytesHandler handler = new BytesHandler(bytes);
                        return new URL(null, "bytes:///", handler);
                    }
                    return new ByteArrayInputStream(bytes);
                }
                if (str.startsWith("image:")) {
                    String encstr = str.substring(6);
                    Object obj = new Base64Cipher().decode(encstr, false);
                    byte[] bytes = (byte[])obj;
                    if (jRField.getValueClass() == URL.class) {
                        BytesHandler handler = new BytesHandler(bytes);
                        return new URL(null, "bytes:///", handler);
                    }
                    return new ByteArrayInputStream(bytes);
                }
                if (Number.class.isAssignableFrom(fieldClass)) {
                    return this.toNumber(fieldClass, str);
                }
                if (fieldClass == Boolean.class) {
                    return this.toBoolean(str);
                }
                return str;
            }
            if (fieldClass.isAssignableFrom(Collection.class)) {
                return new ReportDataSource(value);
            }
            if (fieldClass == String.class) {
                return value.toString();
            }
            return value;
        }
        catch (Throwable ex) {
            System.out.println("Error on field [" + fieldName + "] caused by " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    private Object convertDateObject(Class targetClass, String value) {
        try {
            return new Timestamp(this.YMD_HMS.parse(value).getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Date(this.YMD.parse(value).getTime());
            }
            catch (ParseException ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    private Number toNumber(Class fieldClass, Object value) {
        try {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return (Number)value;
            }
            BigDecimal bd = new BigDecimal(value.toString());
            if (fieldClass == Integer.class) {
                return bd.intValue();
            }
            if (fieldClass == Double.class) {
                return bd.doubleValue();
            }
            if (fieldClass == Float.class) {
                return Float.valueOf(bd.floatValue());
            }
            return bd;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private Boolean toBoolean(Object value) {
        try {
            if (value == null) {
                return null;
            }
            return value.toString().toLowerCase().matches("true|1");
        }
        catch (Throwable t) {
            return null;
        }
    }

    private class BytesConnection
    extends URLConnection {
        private BytesHandler handler;

        public BytesConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.handler.bytes);
        }
    }

    private class BytesHandler
    extends URLStreamHandler {
        private byte[] bytes;

        public BytesHandler(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            BytesConnection bc = new BytesConnection(u);
            bc.handler = this;
            return bc;
        }

        public String getProtocol() {
            return "bytes";
        }

        public URL getResource(String spath) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

