/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.reports;

import com.rameses.rcp.framework.ClientContext;
import java.awt.Graphics;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;

public class JRPrinter
implements Printable {
    private Config config;
    private JasperPrint jprint;
    private int pageOffset;
    private int pageSize;
    private Number zoom_ratio;

    public static Config newConfig() {
        return new Config();
    }

    public JRPrinter(JasperPrint jprint) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.config = new Config();
        this.jprint = jprint;
        Float num = this.config.getZoomRatio(jprint);
        this.zoom_ratio = num == null ? 1.0 : (double)num.floatValue();
    }

    public boolean print(boolean withPrintDialog) {
        this.pageOffset = 0;
        this.pageSize = this.jprint.getPages().size();
        PrinterJob job = PrinterJob.getPrinterJob();
        try {
            job.setPrintService(job.getPrintService());
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
        PageFormat page = job.defaultPage();
        Paper paper = page.getPaper();
        job.setJobName("JRPrinter - " + this.jprint.getName());
        double pw = this.jprint.getPageWidth();
        double ph = this.jprint.getPageHeight();
        if (this.jprint.getOrientation() == 2) {
            page.setOrientation(0);
            paper.setSize(ph, pw);
            paper.setImageableArea(0.0, 0.0, ph, pw);
        } else {
            page.setOrientation(1);
            paper.setSize(pw, ph);
            paper.setImageableArea(0.0, 0.0, pw, ph);
        }
        page.setPaper(paper);
        Book book = new Book();
        book.append(this, page, this.pageSize);
        job.setPageable(book);
        boolean pass = false;
        try {
            if (withPrintDialog) {
                if (job.printDialog()) {
                    job.print();
                    pass = true;
                }
            } else {
                job.print();
                pass = true;
            }
            return pass;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (Thread.currentThread().isInterrupted()) {
            throw new PrinterException("Current thread interrupted");
        }
        if ((pageIndex += this.pageOffset) < 0 || pageIndex >= this.pageSize) {
            return 1;
        }
        try {
            JRGraphics2DExporter exporter = new JRGraphics2DExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.jprint);
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)pageIndex);
            exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)graphics);
            exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.ZOOM_RATIO, (Object)Float.valueOf(this.zoom_ratio.floatValue()));
            exporter.exportReport();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new PrinterException(t.getMessage());
        }
        return 0;
    }

    public static class Config {
        private Config() {
        }

        public Float getZoomRatio(JasperPrint jprint) {
            try {
                String sval = this.getAppEnv(jprint.getName() + ".zoom_ratio");
                return new Float(sval);
            }
            catch (Throwable t) {
                return null;
            }
        }

        String getAppEnv(String name) {
            try {
                Object val = ClientContext.getCurrentContext().getAppEnv().get(name);
                return val == null ? null : val.toString();
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

