/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.reports;

import com.rameses.osiris2.reports.DynamicReportModel;
import com.rameses.rcp.common.Column;
import com.rameses.util.ValueUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;

public class DynamicReportUtil {
    static int fontSize = 8;

    public static JasperDesign build(DynamicReportModel model) {
        JasperDesign jd = new JasperDesign();
        jd.setName(model.getReportName());
        jd.setBottomMargin(model.getBottomMargin());
        jd.setTopMargin(model.getTopMargin());
        jd.setLeftMargin(model.getLeftMargin());
        jd.setRightMargin(model.getRightMargin());
        try {
            int x = 0;
            int y = 0;
            int height = 15;
            int padding = 3;
            JRDesignStyle columnStyle = new JRDesignStyle();
            columnStyle.setName("Column_Style");
            columnStyle.setFontSize(fontSize);
            columnStyle.setVerticalAlignment((byte)2);
            columnStyle.setLeftBorder((byte)5);
            columnStyle.setRightBorder((byte)5);
            columnStyle.setBottomBorder((byte)5);
            columnStyle.setTopBorder((byte)5);
            jd.addStyle((JRStyle)columnStyle);
            JRDesignBand band = new JRDesignBand();
            JRDesignBand dataBand = new JRDesignBand();
            for (Object o : model.getColumns()) {
                Column c = (Column)o;
                String type = c.getType();
                if (type == null || "string".equals(type)) {
                    type = String.class.getName();
                } else if ("decimal".equals(type)) {
                    type = BigDecimal.class.getName();
                } else if ("integer".equals(type)) {
                    type = Integer.class.getName();
                } else if ("boolean".equals(type)) {
                    type = Boolean.class.getName();
                } else if ("double".equals(type)) {
                    type = Double.class.getName();
                } else if ("date".equals(type)) {
                    type = Date.class.getName();
                } else if ("timestamp".equals(type)) {
                    type = Timestamp.class.getName();
                }
                if (c.getWidth() == 0) {
                    c.setWidth(100);
                }
                Class<?> typeClass = DynamicReportUtil.class.getClassLoader().loadClass(type);
                jd.addField(DynamicReportUtil.createField(c.getName(), typeClass));
                band.addElement((JRDesignElement)DynamicReportUtil.createStaticText(c.getCaption(), x, y, c.getWidth(), height, padding, columnStyle));
                dataBand.addElement(DynamicReportUtil.createTextField(c, typeClass, x, y, c.getWidth(), height, padding, columnStyle));
                x += c.getWidth();
            }
            band.setHeight(height);
            dataBand.setHeight(height);
            jd.setColumnHeader((JRBand)band);
            jd.setDetail((JRBand)dataBand);
            String orientation = model.getOrientation() + "";
            if ("landscape".equals(orientation.toLowerCase())) {
                jd.setOrientation((byte)2);
            } else {
                jd.setOrientation((byte)1);
            }
            if (model.getPageHeight() > 0) {
                jd.setPageHeight(model.getPageHeight());
            }
            if (model.getPageWidth() > 0) {
                jd.setPageWidth(model.getPageWidth());
            }
            if (!ValueUtil.isEmpty((Object)model.getReportHeader())) {
                JRDesignBand header = new JRDesignBand();
                JRDesignStyle headerStyle = new JRDesignStyle();
                headerStyle.setName("Header_Style");
                headerStyle.setFontSize(fontSize);
                headerStyle.setBold(true);
                headerStyle.setVerticalAlignment((byte)2);
                headerStyle.setHorizontalAlignment((byte)2);
                jd.addStyle((JRStyle)headerStyle);
                if (model.getReportHeaderHeight() > 0) {
                    height = model.getReportHeaderHeight();
                }
                int width = jd.getPageWidth();
                JRDesignStaticText h = DynamicReportUtil.createStaticText(model.getReportHeader(), 0, 0, width -= model.getLeftMargin() + model.getRightMargin(), height, 3, headerStyle);
                header.addElement((JRDesignElement)h);
                header.setHeight(height);
                jd.setTitle((JRBand)header);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return jd;
    }

    private static JRField createField(String name, Class clz) {
        JRDesignField field = new JRDesignField();
        field.setName(name);
        field.setValueClass(clz);
        return field;
    }

    private static JRDesignVariable createVariable(String name, String varname, Class clz) {
        JRDesignVariable variable = new JRDesignVariable();
        variable.setName(varname);
        variable.setValueClass(clz);
        variable.setCalculation((byte)2);
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(clz);
        exp.setText("$F{" + name + "}");
        variable.setExpression((JRExpression)exp);
        variable.setResetType((byte)1);
        return variable;
    }

    private static JRDesignStaticText createStaticText(String text, int x, int y, int width, int height, int padding, JRDesignStyle columnStyle) {
        JRDesignStaticText st = new JRDesignStaticText();
        st.setText(text);
        st.setX(x);
        st.setY(y);
        st.setWidth(width);
        st.setHeight(height);
        st.setLeftPadding(padding);
        st.setHorizontalAlignment((byte)2);
        st.setStyle((JRStyle)columnStyle);
        st.setPrintWhenDetailOverflows(true);
        return st;
    }

    private static JRDesignElement createTextField(Column c, Class clz, int x, int y, int w, int h, int cellPadding, JRDesignStyle detailStyle) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText("$F{" + c.getName() + "}");
        exp.setValueClass(clz);
        JRDesignTextField tf = new JRDesignTextField();
        tf.setExpression((JRExpression)exp);
        tf.setX(x);
        tf.setY(y);
        tf.setWidth(w);
        tf.setHeight(h);
        tf.setStyle((JRStyle)detailStyle);
        tf.setLeftPadding(cellPadding);
        tf.setBlankWhenNull(Boolean.valueOf(true));
        if (clz.equals(BigDecimal.class)) {
            tf.setPattern("#,##0.00");
            tf.setHorizontalAlignment((byte)3);
            tf.setRightPadding(cellPadding);
        }
        if (!ValueUtil.isEmpty((Object)c.getFormat())) {
            tf.setPattern(c.getFormat());
        }
        if (!ValueUtil.isEmpty((Object)c.getAlignment())) {
            String align = c.getAlignment().toLowerCase();
            if ("right".equals(align)) {
                tf.setHorizontalAlignment((byte)3);
            } else if ("center".equals(align)) {
                tf.setHorizontalAlignment((byte)2);
            } else if ("justified".equals(align)) {
                tf.setHorizontalAlignment((byte)4);
            } else {
                tf.setHorizontalAlignment((byte)1);
            }
        }
        return tf;
    }
}

