/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.undo;

import com.rameses.rcp.draw.interfaces.Editor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class UndoRedoManager
extends UndoManager {
    private Editor editor;
    private boolean undoRedoInProgress = false;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public UndoRedoManager(Editor editor) {
        this.editor = editor;
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
        if (this.undoRedoInProgress) {
            anEdit.die();
            return true;
        }
        return super.addEdit(anEdit);
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        this.undoRedoInProgress = true;
        try {
            super.undo();
        }
        finally {
            this.undoRedoInProgress = false;
            this.editor.getCanvas().refresh();
        }
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        this.undoRedoInProgress = true;
        try {
            super.redo();
        }
        finally {
            this.undoRedoInProgress = false;
            this.editor.getCanvas().refresh();
        }
    }

    public UndoAction getUndoAction() {
        return this.undoAction;
    }

    public RedoAction getRedoAction() {
        return this.redoAction;
    }

    public class RedoAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UndoRedoManager.this.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println("Cannot redo: " + ex);
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UndoRedoManager.this.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println("Cannot undo: " + ex);
            }
        }
    }
}

