/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.tools;

import com.rameses.rcp.draw.figures.WorkflowEndNode;
import com.rameses.rcp.draw.figures.WorkflowStartNode;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.tools.AbstractTool;
import java.awt.event.MouseEvent;

public class WorkflowCreationTool
extends AbstractTool {
    private Figure createdFigure;
    private boolean existing;
    private boolean dragging;

    public WorkflowCreationTool() {
    }

    public WorkflowCreationTool(Editor editor) {
        this(editor, null);
    }

    public WorkflowCreationTool(Editor editor, Class prototype) {
        super(editor);
        this.setPrototype(prototype);
        this.existing = false;
    }

    @Override
    public void mousePressed(int x, int y, MouseEvent e) {
        super.mousePressed(x, y, e);
        this.existing = this.checkExistingFigure();
        if (!this.existing) {
            this.createdFigure = this.createFigure();
            this.createdFigure.setDisplayBox(x, y, x, y);
            this.getEditor().addToDrawing(this.createdFigure);
        }
    }

    @Override
    public void mouseDrag(int x, int y, MouseEvent e) {
        if (this.createdFigure != null) {
            this.createdFigure.setDisplayBox(this.getStartX(), this.getStartY(), x, y);
            this.dragging = true;
        }
    }

    @Override
    public void mouseReleased(int x, int y, MouseEvent e) {
        if (this.createdFigure != null) {
            if (this.createdFigure.isEmpty()) {
                this.getDrawing().removeFigure(this.createdFigure);
            } else {
                this.getCanvas().revalidateRect(this.createdFigure.getDisplayBox());
            }
            this.getEditor().figureAdded(this.createdFigure);
            this.dragging = false;
        }
    }

    private Figure createFigure() {
        try {
            return (Figure)this.getPrototype().newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cancel() {
        this.getDrawing().removeFigure(this.createdFigure);
        this.createdFigure = null;
        this.getEditor().setCurrentTool(this.getEditor().getDefaultTool());
        this.getCanvas().refresh();
    }

    private boolean checkExistingFigure() {
        boolean existing = false;
        if (this.getPrototype() == WorkflowStartNode.class) {
            existing = this.checkExistStartNode();
        } else if (this.getPrototype() == WorkflowEndNode.class) {
            existing = this.checkExistEndNode();
        }
        return existing;
    }

    private boolean checkExistStartNode() {
        for (Figure f : this.getDrawing().getFigures()) {
            if (!(f instanceof WorkflowStartNode)) continue;
            return true;
        }
        return false;
    }

    private boolean checkExistEndNode() {
        for (Figure f : this.getDrawing().getFigures()) {
            if (!(f instanceof WorkflowEndNode)) continue;
            return true;
        }
        return false;
    }
}

