/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.tools;

import com.rameses.rcp.draw.figures.LineConnector;
import com.rameses.rcp.draw.interfaces.Connector;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.tools.AbstractTool;
import com.rameses.rcp.draw.undo.UndoableDrag;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.undo.CompoundEdit;

public class MultiSelectTool
extends AbstractTool {
    private Figure figure;
    private int lastX;
    private int lastY;
    private boolean moved;
    private Map<Figure, Point> initialFigureLocations;

    public MultiSelectTool() {
    }

    public MultiSelectTool(Editor editor, Figure figure) {
        super(editor);
        this.figure = figure;
        this.moved = false;
    }

    @Override
    public void mousePressed(int x, int y, MouseEvent e) {
        super.mousePressed(x, y, e);
        this.lastX = x;
        this.lastY = y;
        if (e.isShiftDown()) {
            this.getDrawing().toggleSelection(this.figure);
            this.figure = null;
        } else if (!this.getDrawing().isFigureSelected(this.figure)) {
            this.getDrawing().clearSelections();
            this.getDrawing().addSelection(this.figure);
        }
    }

    @Override
    public void mouseDrag(int x, int y, MouseEvent e) {
        super.mouseDrag(x, y, e);
        boolean bl = this.moved = Math.abs(x - this.getStartX()) > 4 || Math.abs(y - this.getStartY()) > 4;
        if (this.moved && !this.getEditor().isReadonly()) {
            int dx = x - this.lastX;
            int dy = y - this.lastY;
            this.preservePreviousFigureLocations();
            for (Figure f : this.getDrawing().getSelections()) {
                if (f instanceof LineConnector) continue;
                f.moveBy(dx, dy, e);
            }
        }
        this.lastX = x;
        this.lastY = y;
    }

    @Override
    public void mouseReleased(int x, int y, MouseEvent e) {
        if (this.moved && this.initialFigureLocations != null) {
            this.logUndoableMove(x, y);
        }
    }

    @Override
    public Cursor getToolCursor() {
        return new Cursor(12);
    }

    private void logUndoableMove(int x, int y) {
        int dx = x - this.getStartX();
        int dy = y - this.getStartY();
        CompoundEdit ce = new CompoundEdit();
        for (Figure f : this.getDrawing().getSelections()) {
            ce.addEdit(new UndoableDrag(f, this.initialFigureLocations.get(f), dx, dy));
        }
        ce.end();
        this.getEditor().addUndoableEdit(ce);
    }

    private void preservePreviousFigureLocations() {
        if (this.initialFigureLocations == null) {
            this.initialFigureLocations = new HashMap<Figure, Point>();
            for (Figure f : this.getDrawing().getSelections()) {
                if (f instanceof Connector) continue;
                this.initialFigureLocations.put(f, f.getLocation());
            }
        }
    }
}

