/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.tools;

import com.rameses.rcp.draw.figures.LineFigure;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.tools.AbstractTool;
import java.awt.event.MouseEvent;

public class LineTool
extends AbstractTool {
    private LineFigure createdFigure;

    public LineTool() {
    }

    public LineTool(Editor editor) {
        this(editor, null);
    }

    public LineTool(Editor editor, Class<LineFigure> prototype) {
        super(editor);
        this.setPrototype(prototype);
    }

    @Override
    public void mousePressed(int x, int y, MouseEvent e) {
        super.mousePressed(x, y, e);
        this.createdFigure = this.createFigure(x, y);
        this.getEditor().addToDrawing(this.createdFigure);
    }

    @Override
    public void mouseDrag(int x, int y, MouseEvent e) {
        this.createdFigure.updateEndPoint(x, y);
    }

    @Override
    public void mouseReleased(int x, int y, MouseEvent e) {
        if (this.createdFigure.isEmpty()) {
            this.getDrawing().removeFigure(this.createdFigure);
        } else {
            this.getEditor().figureAdded(this.createdFigure);
            this.getCanvas().revalidateRect(this.createdFigure.getDisplayBox());
        }
    }

    private LineFigure createFigure(int x, int y) {
        try {
            LineFigure f = new LineFigure();
            f.addPoint(x, y);
            f.addPoint(x, y);
            return f;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

