/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.support;

import com.rameses.rcp.draw.support.XmlAttribute;
import java.util.ArrayList;
import java.util.List;

public class XmlElement {
    private String tagName;
    private List<XmlElement> children;
    private List<XmlAttribute> attributes;

    public XmlElement() {
        this(null);
    }

    public XmlElement(String tagName) {
        this.tagName = tagName;
        this.children = new ArrayList<XmlElement>();
        this.attributes = new ArrayList<XmlAttribute>();
    }

    public void addAttribute(String key, Object value) {
        if (value != null) {
            XmlAttribute attr = new XmlAttribute(key, value);
            if (this.attributes.contains(attr)) {
                int idx = this.attributes.indexOf(attr);
                this.attributes.set(idx, attr);
            } else {
                this.attributes.add(attr);
            }
        }
    }

    public void addChildElement(XmlElement element) {
        this.children.add(element);
    }

    public void removeChildElement(XmlElement element) {
        this.children.remove(element);
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public List<XmlAttribute> getAttributes() {
        return this.attributes;
    }

    public List<XmlElement> getChildren() {
        return this.children;
    }

    public String toXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<" + this.getTagName());
        sb.append(this.attributesToXml());
        if (this.getChildren().isEmpty()) {
            sb.append(" />\n");
        } else {
            sb.append(">\n");
            for (XmlElement e : this.children) {
                sb.append(e.toXml());
            }
            sb.append("</" + this.getTagName() + ">\n");
        }
        return sb.toString();
    }

    protected String attributesToXml() {
        if (this.getAttributes().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" ");
        for (XmlAttribute attr : this.getAttributes()) {
            sb.append(attr.toXml());
        }
        return sb.toString();
    }
}

