/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.figures;

import com.rameses.rcp.draw.figures.WorkflowNode;
import com.rameses.rcp.draw.support.AttributeKeys;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class WorkflowSender
extends WorkflowNode {
    @Override
    public String getToolCaption() {
        return "Sender";
    }

    @Override
    public String getType() {
        return "sender";
    }

    @Override
    public String getIcon() {
        return "images/draw/workflow-sender16.png";
    }

    @Override
    protected void drawNodeSymbol(Graphics2D g) {
        Point[] pts = this.getPolyPoints();
        int[] xpts = new int[5];
        int[] ypts = new int[5];
        for (int i = 0; i < pts.length; ++i) {
            xpts[i] = pts[i].x;
            ypts[i] = pts[i].y;
        }
        g.setStroke(AttributeKeys.getStroke(this));
        g.setColor(this.get(AttributeKeys.FILL_COLOR));
        g.fillPolygon(xpts, ypts, pts.length);
        g.setColor(this.get(AttributeKeys.STROKE_COLOR));
        g.drawPolygon(xpts, ypts, pts.length);
    }

    private Point[] getPolyPoints() {
        Rectangle r = this.getDisplayBox();
        float slopeOffset = 0.8f;
        int nw = (int)((float)r.width * slopeOffset);
        int cy = r.y + r.height / 2;
        Point[] pts = new Point[]{new Point(r.x, r.y), new Point(r.x + nw, r.y), new Point(r.x + r.width, cy), new Point(r.x + nw, r.y + r.height), new Point(r.x, r.y + r.height)};
        return pts;
    }
}

