/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.figures;

import com.rameses.rcp.draw.figures.ImageFigure;
import com.rameses.rcp.draw.interfaces.Tool;
import com.rameses.rcp.draw.support.AttributeKeys;
import com.rameses.rcp.draw.tools.WorkflowCreationTool;
import com.rameses.rcp.draw.utils.DrawUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class WorkflowNode
extends ImageFigure {
    public WorkflowNode() {
        this.set(AttributeKeys.FILL_COLOR, Color.LIGHT_GRAY);
    }

    @Override
    public String getCategory() {
        return "workflow";
    }

    @Override
    public String getToolCaption() {
        return "Node";
    }

    @Override
    public String getType() {
        return "process";
    }

    @Override
    public String getIcon() {
        return "images/draw/workflow-node16.png";
    }

    @Override
    public Tool getTool() {
        return new WorkflowCreationTool();
    }

    @Override
    protected void drawFigure(Graphics2D g) {
        if (this.getImage() == null) {
            this.drawNodeSymbol(g);
            this.drawCaption(g);
        } else {
            super.drawFigure(g);
        }
    }

    protected void drawNodeSymbol(Graphics2D g) {
        Rectangle r = this.getDisplayBox();
        g.setStroke(AttributeKeys.getStroke(this));
        g.setColor(this.get(AttributeKeys.FILL_COLOR));
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(this.get(AttributeKeys.STROKE_COLOR));
        g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
    }

    @Override
    public boolean isEmpty() {
        Rectangle r = this.getDisplayBox();
        return r.width <= 2 || r.height <= 2;
    }

    @Override
    protected void drawIndex(Graphics2D g) {
        Rectangle r = this.getDisplayBox();
        Dimension ts = DrawUtil.getTextSize(g, this.getIndex() + "");
        int x = r.x + (r.width - ts.width) / 2;
        int y = r.y + r.height + ts.height - 4;
        g.setColor(Color.RED);
        g.drawString(this.getIndex() + "", x, y);
    }
}

