/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.decorators;

import com.rameses.rcp.draw.decorators.AbstractLineDecoration;
import com.rameses.rcp.draw.interfaces.Figure;
import java.awt.geom.Path2D;

public class ArrowTip
extends AbstractLineDecoration {
    private double angle;
    private double outerRadius;
    private double innerRadius;

    public ArrowTip() {
        this(0.35, 12.0, 11.3);
    }

    public ArrowTip(double angle, double outerRadius, double innerRadius) {
        this(angle, outerRadius, innerRadius, true, false, true);
    }

    public ArrowTip(double angle, double outerRadius, double innerRadius, boolean filled, boolean stroked, boolean solid) {
        super(filled, stroked, solid);
        this.angle = angle;
        this.outerRadius = outerRadius;
        this.innerRadius = innerRadius;
    }

    @Override
    protected Path2D.Double getDecoratorPath(Figure figure) {
        double offset = this.isStroked() ? 1.0 : 0.0;
        Path2D.Double path = new Path2D.Double();
        path.moveTo(this.outerRadius * Math.sin(-this.angle), offset + this.outerRadius * Math.cos(-this.angle));
        path.lineTo(0.0, offset);
        path.lineTo(this.outerRadius * Math.sin(this.angle), offset + this.outerRadius * Math.cos(this.angle));
        if (this.innerRadius != 0.0) {
            path.lineTo(0.0, this.innerRadius + offset);
            path.closePath();
        }
        return path;
    }

    @Override
    protected double getDecoratorPathRadius(Figure figure) {
        double offset = this.isStroked() ? 0.5 : -0.1;
        return this.innerRadius + offset;
    }
}

