/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.components;

import com.rameses.rcp.draw.components.AttributePickerModel;
import com.rameses.rcp.draw.support.AttributeKey;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class ColorButton
extends JButton
implements ActionListener {
    private Color color;
    private AttributePickerModel model;
    private AttributeKey key;

    public ColorButton(AttributePickerModel model, Color color) {
        this(model, null, color);
    }

    public ColorButton(AttributePickerModel model, AttributeKey key, Color color) {
        this.model = model;
        this.color = color;
        this.key = key;
        this.setPreferredSize(new Dimension(12, 12));
        this.addActionListener(this);
    }

    @Override
    public void paint(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(this.color);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(oldColor);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.key != null) {
            this.model.getEditor().attributeChanged(this.key, this.color);
        } else {
            this.model.getEditor().attributeChanged(this.model.getAttributeKey(), this.color);
        }
    }
}

