/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw.commands;

import com.rameses.rcp.draw.commands.Command;
import com.rameses.rcp.draw.figures.TextFigure;
import com.rameses.rcp.draw.interfaces.Canvas;
import com.rameses.rcp.draw.interfaces.Figure;
import com.rameses.rcp.draw.support.AttributeKeys;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;

public class CenterTextCommand
extends Command {
    public CenterTextCommand(Canvas canvas) {
        super("draw_cente_text", canvas);
    }

    @Override
    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(67, 640, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Figure> selections = this.getEditor().getDrawing().getSelections();
        if (!selections.isEmpty()) {
            Figure figure = selections.get(0);
            boolean newValue = figure.get(AttributeKeys.CENTER_TEXT) == false;
            this.getEditor().attributeChanged(AttributeKeys.CENTER_TEXT, newValue);
            if (newValue) {
                for (Figure f : selections) {
                    Figure parent;
                    if (!(f instanceof TextFigure) || (parent = ((TextFigure)f).getParentFigure()) == null) continue;
                    parent.setDisplayBox(parent.getDisplayBox());
                }
            }
        }
    }
}

