/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.draw;

import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.control.border.XLineBorder;
import com.rameses.rcp.draw.commands.Commands;
import com.rameses.rcp.draw.interfaces.Canvas;
import com.rameses.rcp.draw.interfaces.Drawing;
import com.rameses.rcp.draw.interfaces.Editor;
import com.rameses.rcp.draw.interfaces.Tool;
import com.rameses.rcp.draw.utils.DrawUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class DrawCanvas
extends JPanel
implements Canvas {
    private Editor editor;
    private boolean readonly;
    private MenuProxy menu;
    private Rectangle selectionArea;
    private CanvasMouseAdapter canvasMouseAdapter;
    private Commands keyHandlers;

    public DrawCanvas() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setReadonly(false);
        this.setFocusable(true);
        this.addMouseListeners();
        this.setBackground(Color.WHITE);
        this.setBorder(this.createLineBorder());
        this.createKeyBindings();
    }

    @Override
    public Editor getEditor() {
        return this.editor;
    }

    @Override
    public void setEditor(Editor editor) {
        this.editor = editor;
        this.editor.setCanvas(this);
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.getDrawing() != null) {
            this.getDrawing().draw(g);
        }
        this.drawSelectionArea(g);
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    @Override
    public void revalidateRect(Rectangle area) {
        this.scrollRectToVisible(area);
        Rectangle pf = new Rectangle();
        Rectangle r = this.getDrawing().getBounds();
        pf.add(new Point(r.x + r.width + 10, r.y + r.height + 10));
        this.setPreferredSize(pf.getSize());
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        DrawUtil.setHDRenderingHints(g);
        this.draw((Graphics2D)g);
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public Container getContainer() {
        return this;
    }

    @Override
    public void showMenu(int sx, int sy, List menus) {
        if (this.menu != null) {
            this.menu.setVisible(false);
        }
        this.menu = new MenuProxy(menus);
        Rectangle r = this.getBounds();
        this.menu.setLocation(sx, sy);
        this.menu.setVisible(true);
    }

    @Override
    public void hideMenu() {
        if (this.menu != null && this.menu.isVisible()) {
            this.menu.setVisible(false);
        }
    }

    @Override
    public void setSelectionArea(Rectangle selectionArea) {
        this.selectionArea = selectionArea;
    }

    @Override
    public Drawing getDrawing() {
        if (this.getEditor() == null) {
            return null;
        }
        return this.getEditor().getDrawing();
    }

    public Tool getTool() {
        if (this.getEditor() == null) {
            return null;
        }
        return this.getEditor().getCurrentTool();
    }

    protected void handleMouseClicked(int x, int y, MouseEvent e) {
        if (this.getTool() != null) {
            this.getTool().mouseClicked(x, y, e);
        }
        this.hideMenu();
    }

    protected void handleRightButton(int x, int y, int sx, int sy, MouseEvent e) {
        if (this.getTool() != null) {
            this.getTool().showMenu(x, y, sx, sy, e);
        }
    }

    protected void handleMousePressed(int x, int y, MouseEvent e) {
        if (this.getTool() != null) {
            this.getTool().mousePressed(x, y, e);
        }
    }

    protected void handleMouseReleased(int x, int y, MouseEvent e) {
        if (this.getTool() != null) {
            this.getTool().mouseReleased(x, y, e);
            this.repaint();
        }
    }

    protected void handleMouseDrag(int x, int y, MouseEvent e) {
        if (this.getTool() != null) {
            this.getTool().mouseDrag(x, y, e);
            this.repaint();
        }
    }

    protected void handleMouseMoved(int x, int y, MouseEvent e) {
        if (this.getTool() != null) {
            this.getTool().mouseMoved(x, y, e);
            this.repaint();
        }
    }

    private Border createLineBorder() {
        XLineBorder b = new XLineBorder();
        b.setLineColor(Color.LIGHT_GRAY);
        return b;
    }

    private void addMouseListeners() {
        if (this.canvasMouseAdapter == null) {
            this.canvasMouseAdapter = new CanvasMouseAdapter();
        }
        this.addMouseListener(this.canvasMouseAdapter);
        this.addMouseMotionListener(this.canvasMouseAdapter);
    }

    private void removeMouseListeners() {
        this.removeMouseListener(this.canvasMouseAdapter);
        this.removeMouseMotionListener(this.canvasMouseAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawSelectionArea(Graphics2D g) {
        if (this.selectionArea == null) {
            return;
        }
        Graphics2D g2 = null;
        try {
            g2 = (Graphics2D)g.create();
            BasicStroke dashedStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 5.0f, 5.0f, 5.0f}, 5.0f);
            g2.setStroke(dashedStroke);
            g2.setXORMode(this.getBackground());
            g2.setColor(Color.BLACK);
            g2.drawRect(this.selectionArea.x, this.selectionArea.y, this.selectionArea.width, this.selectionArea.height);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
    }

    private void createKeyBindings() {
        Commands c = new Commands(this);
        c.registerCommands();
    }

    class MenuItemAction
    extends JMenuItem
    implements ActionListener {
        private MenuProxy menu;
        private final Opener opener;

        public MenuItemAction(MenuProxy menu, Opener opener) {
            this.menu = menu;
            this.opener = opener;
            this.setText(opener.getCaption());
            this.setActionCommand(opener.getAction());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InvokerUtil.invoke((Opener)this.opener);
            this.menu.setVisible(false);
        }
    }

    class MenuProxy
    extends JPopupMenu {
        public MenuProxy(List<Opener> menus) {
            for (Opener inv : menus) {
                this.add(new MenuItemAction(this, inv));
            }
        }
    }

    class CanvasMouseAdapter
    extends MouseAdapter {
        CanvasMouseAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!DrawCanvas.this.readonly) {
                DrawCanvas.this.handleMouseDrag(e.getX(), e.getY(), e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!DrawCanvas.this.readonly) {
                DrawCanvas.this.handleMouseMoved(e.getX(), e.getY(), e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                DrawCanvas.this.handleRightButton(e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e);
            } else {
                DrawCanvas.this.handleMouseClicked(e.getX(), e.getY(), e);
            }
            if (!DrawCanvas.this.isFocusOwner()) {
                DrawCanvas.this.requestFocus();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!DrawCanvas.this.readonly) {
                DrawCanvas.this.handleMousePressed(e.getX(), e.getY(), e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!DrawCanvas.this.readonly) {
                DrawCanvas.this.handleMouseReleased(e.getX(), e.getY(), e);
            }
        }
    }
}

