/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.OSManager;
import com.rameses.osiris3.platform.OSPlatform;
import com.rameses.osiris3.platform.OSView;
import com.rameses.osiris3.platform.WindowContainer;
import com.rameses.platform.interfaces.ContentPane;
import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.SubWindowListener;
import com.rameses.platform.interfaces.ViewContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.rmi.server.UID;
import java.util.Map;
import javax.swing.JPanel;

class SubWindowImpl
extends JPanel
implements SubWindow,
ContentPane {
    private String id;
    private String title;
    private boolean canClose = true;
    private OSPlatform platform;
    private ViewContext viewContext;
    private DefaultLayout defaultLayout;
    private OSView view;
    private SubWindowListener listener;

    public SubWindowImpl(String id, Component comp, OSPlatform platform) {
        this(id, comp, platform, true);
    }

    public SubWindowImpl(String id, Component comp, OSPlatform platform, boolean canClose) {
        this.id = id == null ? "WIN" + new UID() : id;
        this.platform = platform;
        this.canClose = canClose;
        if (comp instanceof ViewContext) {
            this.viewContext = (ViewContext)((Object)comp);
            this.viewContext.setSubWindow(this);
        }
        this.defaultLayout = new DefaultLayout();
        super.setLayout(this.defaultLayout);
        this.add(comp);
    }

    @Override
    public LayoutManager getLayout() {
        return this.defaultLayout;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setView(OSView view) {
        this.view = view;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.removeAll();
        super.addImpl(comp, constraints, -1);
    }

    @Override
    public void activate() {
        if (this.viewContext != null) {
            this.viewContext.activate();
        }
    }

    @Override
    public void setListener(SubWindowListener listener) {
        this.listener = listener;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        if (this.listener != null) {
            this.listener.fireUpdate(this);
        }
    }

    @Override
    public void closeWindow() {
        this.close();
    }

    @Override
    public void update(Map attrs) {
        Object otitle;
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        Object oid = attrs.remove("id");
        if (oid != null) {
            this.id = oid.toString();
        }
        if ((otitle = attrs.remove("title")) != null) {
            this.title = otitle.toString();
        }
        if (this.listener != null) {
            this.listener.fireUpdate(this);
        }
    }

    @Override
    public boolean isCanClose() {
        return this.canClose;
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
    }

    @Override
    public void close() {
        WindowContainer wc;
        if (!this.isCanClose()) {
            return;
        }
        if (this.viewContext != null && !this.viewContext.close()) {
            return;
        }
        if (this.view != null && (wc = this.view.getWindowContainer()) != null) {
            wc.remove(this);
        }
        OSManager.getInstance().unregisterView(this.getId());
    }

    @Override
    public ContentPane.View getView() {
        Component[] comps;
        for (Component c : comps = this.getComponents()) {
            if (!c.isVisible() || !(c instanceof ContentPane.View)) continue;
            return (ContentPane.View)((Object)c);
        }
        return null;
    }

    private class DefaultLayout
    implements LayoutManager {
        private DefaultLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component comp = this.getFirstVisible(parent);
                if (comp != null) {
                    Dimension dim = comp.getPreferredSize();
                    w = dim.width;
                    h = dim.height;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        private Component getFirstVisible(Container parent) {
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].isVisible()) continue;
                return comps[i];
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component comp = this.getFirstVisible(parent);
                if (comp == null) {
                    return;
                }
                Dimension dim = comp.getPreferredSize();
                comp.setBounds(x, y, w, h);
            }
        }
    }
}

