/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.OSPlatformIdentity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

class OSStartupWindow
extends JFrame {
    private ImageCanvas imageCanvas;
    private ImageIcon iicon;
    private Color lineColor;
    private Color textColor;
    private Rectangle textPosition;
    private Rectangle progressPosition;

    public OSStartupWindow() {
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setAlwaysOnTop(true);
        this.imageCanvas = new ImageCanvas();
        this.textColor = new Color(0, 0, 0);
        this.imageCanvas.lblText.setForeground(this.textColor);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add(this.imageCanvas);
        this.setSize(480, 300);
    }

    public void setImageIcon(ImageIcon iicon) {
        this.iicon = iicon;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
        this.imageCanvas.lblText.setForeground(textColor);
    }

    public void setTextPosition(Rectangle textPosition) {
        this.textPosition = textPosition;
        this.imageCanvas.lblText.setBounds(textPosition);
    }

    public void setProgressPosition(Rectangle progressPosition) {
        this.progressPosition = progressPosition;
        this.imageCanvas.progressbar.setBounds(progressPosition);
    }

    public void setTextValue(String value) {
        this.imageCanvas.lblText.setText(value);
        this.imageCanvas.lblText.revalidate();
        this.imageCanvas.lblText.repaint();
    }

    public void center() {
        Dimension scrdim = Toolkit.getDefaultToolkit().getScreenSize();
        Insets margin = Toolkit.getDefaultToolkit().getScreenInsets(this.imageCanvas.getGraphicsConfiguration());
        scrdim.width -= margin.left + margin.right;
        scrdim.height -= margin.top + margin.bottom;
        Dimension windim = this.getSize();
        int x = Math.max(scrdim.width / 2 - windim.width / 2, 0);
        int y = Math.max(scrdim.height / 2 - windim.height / 2, 0);
        this.setLocation(x, y);
    }

    @Override
    public void setVisible(boolean b) {
        this.beforeVisible();
        super.setVisible(true);
    }

    private void beforeVisible() {
        OSPlatformIdentity spi = OSPlatformIdentity.getInstance();
        ImageIcon splashIcon = spi.getIcon("splash");
        ImageIcon winIcon = spi.getIcon("icon");
        if (winIcon == null) {
            winIcon = spi.getDefaultIcon();
        }
        try {
            this.setImageIcon(splashIcon);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.setIconImage(winIcon.getImage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.center();
    }

    private class ImageCanvas
    extends JPanel {
        OSStartupWindow root;
        JProgressBar progressbar;
        JLabel lblText;

        ImageCanvas() {
            this.root = OSStartupWindow.this;
            this.setLayout(null);
            this.lblText = new JLabel("Downloading updates please wait...");
            this.lblText.setFont(Font.decode("dialog-plain-10"));
            Dimension dim = this.lblText.getPreferredSize();
            this.lblText.setBounds(new Rectangle(20, 230, 440, dim.height));
            this.add(this.lblText);
            this.progressbar = new JProgressBar();
            this.progressbar.setIndeterminate(true);
            this.progressbar.setBounds(new Rectangle(20, 245, 440, 10));
            this.add(this.progressbar);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.root.iicon == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            g2.drawImage(OSStartupWindow.this.iicon.getImage(), 0, 0, this.getWidth(), this.getHeight(), null);
            g2.dispose();
        }

        public void setText(String text) {
            this.lblText.setText(text);
            this.lblText.revalidate();
            this.lblText.repaint();
        }
    }
}

