/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.ModuleEntry;
import com.rameses.osiris3.platform.UpdateCenterUtil;
import com.rameses.osiris3.platform.UpdateConf;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class UpdateCenter {
    private String appPath = System.getProperty("user.dir") + "/osiris2";
    private String appurl;
    private URL[] urls;
    private Map env;
    private Handler handler;

    public UpdateCenter(String appurl) {
        this.appurl = appurl;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public URL[] getUrls() {
        return this.urls;
    }

    public Map getEnv() {
        return this.env;
    }

    public ClassLoader getClassLoader(ClassLoader sourceClassLoader) {
        if (this.urls == null) {
            return sourceClassLoader;
        }
        return new URLClassLoader(this.urls, sourceClassLoader);
    }

    public void start() throws Exception {
        System.out.println("starting update");
        if (this.handler != null) {
            this.handler.onmessage("Checking for updates...");
        }
        String hostPath = UpdateCenterUtil.buildHostPath(this.appurl);
        UpdateConf conf = UpdateCenterUtil.getUpdateConf(this.appurl, this.appPath);
        List<String> oldList = UpdateCenterUtil.getExistingFiles(conf.getModulePath());
        ArrayList<ModuleEntry> forDownload = new ArrayList<ModuleEntry>();
        for (ModuleEntry moduleEntry : conf.getModules()) {
            String fileName = moduleEntry.getFilename();
            boolean existing = oldList.remove(fileName);
            if (existing) continue;
            forDownload.add(moduleEntry);
        }
        for (String string : oldList) {
            File ff = new File(conf.getModulePath() + string);
            ff.delete();
        }
        int index = 0;
        for (ModuleEntry me : forDownload) {
            System.out.println("... updating " + me.getFilename());
            if (this.handler != null) {
                this.handler.ondownload(me);
            }
            UpdateCenterUtil.download(hostPath, me);
            ++index;
        }
        this.env = conf.getEnv();
        this.urls = new URL[conf.getModules().size()];
        boolean bl = false;
        for (ModuleEntry me : conf.getModules()) {
            this.urls[++var6_12] = me.getURL();
        }
        if (this.handler != null) {
            this.handler.oncomplete();
        }
    }

    public static interface Handler {
        public void onmessage(String var1);

        public void ondownload(ModuleEntry var1);

        public void oncomplete();
    }
}

