/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.OSManager;
import com.rameses.osiris3.platform.OSTabbedView;
import com.rameses.osiris3.platform.OSView;
import com.rameses.osiris3.platform.WindowContainer;
import com.rameses.platform.interfaces.ContentPane;
import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.SubWindowContainer;
import com.rameses.platform.interfaces.SubWindowListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.rmi.server.UID;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

class OSTabbedPane_1
extends JTabbedPane
implements SubWindowContainer {
    private Map<String, Component> tabIndex = new Hashtable<String, Component>();
    private Rectangle closeIconBounds = new Rectangle(0, 0, 10, 10);
    private boolean closeIconHover;

    public OSTabbedPane_1() {
        this.setFocusable(false);
        TabSupport support = new TabSupport();
        this.addMouseListener(support);
        this.addMouseMotionListener(support);
    }

    public boolean containsView(String id) {
        return this.tabIndex.get(id) != null;
    }

    public Component findWindow(String id) {
        return this.tabIndex.get(id);
    }

    @Override
    protected void paintComponent(Graphics g) {
        ContentPane cp;
        super.paintComponent(g);
        Component comp = this.getSelectedComponent();
        if (comp instanceof ContentPane && !(cp = (ContentPane)((Object)comp)).isCanClose()) {
            return;
        }
        int idx = this.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        Rectangle rec = this.getBoundsAt(idx);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.closeIconBounds.width;
        int h = this.closeIconBounds.height;
        int x = rec.x + rec.width - w - 8;
        int y = rec.y + rec.height / 2 - h / 2;
        g2.setColor(this.closeIconHover ? Color.RED : Color.BLACK);
        g2.drawLine(x + 2, y + 2, x + w - 3, y + h - 3);
        g2.drawLine(x + w - 3, y + 2, x + 2, y + h - 3);
        this.closeIconBounds.x = x;
        this.closeIconBounds.y = y;
        g2.setColor(this.closeIconHover ? UIManager.getColor("Separator.shadow") : UIManager.getColor("control"));
        Rectangle cib = this.closeIconBounds;
        g2.drawRoundRect(cib.x, cib.y, cib.width - 1, cib.height - 1, 3, 3);
        g2.dispose();
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        final String _title = title + "          ";
        final Icon _icon = icon;
        final Component _component = component;
        final String _tip = tip;
        final int _index = index;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                OSTabbedPane_1.this.insertTabImpl(_title, _icon, _component, _tip, _index);
            }
        });
    }

    private void insertTabImpl(String title, Icon icon, Component component, String tip, int index) {
        String s;
        Component old;
        String tabid = component.getName();
        if (tabid == null) {
            tabid = "WIN" + new UID();
            component.setName(tabid);
        }
        if ((old = this.tabIndex.get(tabid)) != null && this.indexOfComponent(old) >= 0) {
            this.setSelectedComponent(old);
            return;
        }
        if (component instanceof OSTabbedView && (s = ((OSTabbedView)component).getTitle()) != null && s.trim().length() > 0) {
            title = s + "          ";
        }
        super.insertTab(title, icon, component, tip, index);
        this.setSelectedIndex(index);
        this.tabIndex.put(tabid, component);
        OSManager.getInstance().registerView(tabid, new OSViewImpl(component));
    }

    @Override
    public void remove(Component component) {
        int idx = this.indexOfComponent(component);
        if (idx >= 0) {
            String title = this.getTitleAt(idx);
            this.tabIndex.remove(title);
            String cname = component.getName();
            if (cname != null) {
                this.tabIndex.remove(cname);
                OSManager.getInstance().unregisterView(cname);
            }
        }
        super.remove(component);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.tabIndex.clear();
    }

    public void showInfo() {
        Component comp = this.getSelectedComponent();
        if (!(comp instanceof ContentPane)) {
            return;
        }
        ContentPane cp = (ContentPane)((Object)comp);
        ContentPane.View vw = cp.getView();
        if (vw != null) {
            vw.showInfo();
        }
    }

    @Override
    public void add(SubWindow window) {
        if (!(window instanceof JComponent)) {
            throw new IllegalStateException("window parameter must be an instance of SubWindow and JComponent");
        }
        JComponent jc = (JComponent)((Object)window);
        jc.putClientProperty("SubWindow.id", window.getName());
        window.setListener(new SubWindowHandler());
        this.addTab(window.getTitle(), jc);
    }

    private class OSViewImpl
    implements OSView {
        OSTabbedPane_1 root;
        Component view;

        OSViewImpl(Component view) {
            this.root = OSTabbedPane_1.this;
            this.view = view;
        }

        @Override
        public String getId() {
            return this.view.getName();
        }

        @Override
        public String getType() {
            return "tab";
        }

        @Override
        public void requestFocus() {
            if (this.view instanceof OSTabbedView) {
                ((OSTabbedView)this.view).activate();
            }
        }

        @Override
        public void closeView() {
            this.root.remove(this.view);
        }

        @Override
        public WindowContainer getWindowContainer() {
            return null;
        }
    }

    private class TabSupport
    implements MouseListener,
    MouseMotionListener {
        private TabSupport() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Component comp;
            if (OSTabbedPane_1.this.closeIconBounds.contains(e.getPoint()) && (comp = OSTabbedPane_1.this.getSelectedComponent()) instanceof ContentPane) {
                ((ContentPane)((Object)comp)).close();
                OSTabbedPane_1.this.closeIconHover = false;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            OSTabbedPane_1.this.closeIconHover = false;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (OSTabbedPane_1.this.closeIconBounds.contains(e.getPoint())) {
                OSTabbedPane_1.this.closeIconHover = true;
            } else {
                OSTabbedPane_1.this.closeIconHover = false;
            }
        }
    }

    private class SubWindowHandler
    implements SubWindowListener {
        private SubWindowHandler() {
        }

        @Override
        public void fireUpdate(SubWindow window) {
            if (window == null) {
                return;
            }
            if (!(window instanceof Component)) {
                throw new IllegalStateException("window parameter must be an instance of SubWindow and Component");
            }
            JComponent jc = (JComponent)((Object)window);
            int index = OSTabbedPane_1.this.indexOfComponent(jc);
            if (index < 0) {
                return;
            }
            OSTabbedPane_1.this.setTitleAt(index, window.getTitle() + "          ");
            String newId = window.getName();
            String oldId = jc.getClientProperty("SubWindow.id") + "";
            if (oldId != null && newId != null && !oldId.equals(newId)) {
                OSTabbedPane_1.this.tabIndex.remove(oldId);
                OSTabbedPane_1.this.tabIndex.put(newId, jc);
            }
            jc.putClientProperty("SubWindow.id", newId);
        }
    }
}

