/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.util;

import java.beans.FeatureDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ResourceBundleELResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleResolver
extends ELResolver {
    private static final ELResolver DEFAULT_RESOLVER_READ_ONLY = new CompositeELResolver(){
        {
            this.add(new ArrayELResolver(true));
            this.add(new ListELResolver(true));
            this.add(new MapELResolver(true));
            this.add(new ResourceBundleELResolver());
            this.add(new BeanELResolver(true));
        }
    };
    private static final ELResolver DEFAULT_RESOLVER_READ_WRITE = new CompositeELResolver(){
        {
            this.add(new ArrayELResolver(false));
            this.add(new ListELResolver(false));
            this.add(new MapELResolver(false));
            this.add(new ResourceBundleELResolver());
            this.add(new BeanELResolver(false));
        }
    };
    private final Map<Object, Object> map = Collections.synchronizedMap(new HashMap());
    private final ELResolver delegate;
    private final boolean readOnly;

    public SimpleResolver(ELResolver delegate, boolean readOnly) {
        this.delegate = delegate;
        this.readOnly = readOnly;
    }

    public SimpleResolver(ELResolver delegate) {
        this(delegate, false);
    }

    public SimpleResolver(boolean readOnly) {
        this(readOnly ? DEFAULT_RESOLVER_READ_ONLY : DEFAULT_RESOLVER_READ_WRITE, readOnly);
    }

    public SimpleResolver() {
        this(DEFAULT_RESOLVER_READ_WRITE, false);
    }

    private boolean resolve(ELContext context, Object base) {
        context.setPropertyResolved(base == null);
        return context.isPropertyResolved();
    }

    private Object get(Object property) throws PropertyNotFoundException {
        if (this.map.containsKey(property)) {
            return this.map.get(property);
        }
        throw new PropertyNotFoundException("Cannot find property " + property);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return this.resolve(context, base) ? Object.class : this.delegate.getCommonPropertyType(context, base);
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return this.resolve(context, base) ? null : this.delegate.getFeatureDescriptors(context, base);
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        return this.resolve(context, base) ? Object.class : this.delegate.getType(context, base, property);
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        return this.resolve(context, base) ? this.get(property) : this.delegate.getValue(context, base, property);
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        return this.resolve(context, base) ? this.readOnly : this.delegate.isReadOnly(context, base, property);
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (this.resolve(context, base)) {
            if (this.readOnly) {
                throw new PropertyNotWritableException("resolver is read only!");
            }
            this.map.put(property, value);
        } else {
            this.delegate.setValue(context, base, property, value);
        }
    }
}

